/*
 * Decompiled with CFR 0.152.
 */
package net.swisstech.bitly.builder;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.swisstech.bitly.BitlyClientException;
import net.swisstech.bitly.builder.QueryParameter;
import net.swisstech.bitly.gson.GsonFactory;
import net.swisstech.bitly.model.Response;
import net.swisstech.bitly.model.ResponsePartial;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request<T> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Request.class.getName());
    private static final Gson GSON = GsonFactory.getGson();
    private final String accessToken;
    private List<QueryParameter> queryParameters = new LinkedList<QueryParameter>();

    public Request(String accessToken) {
        this.accessToken = accessToken;
    }

    public List<QueryParameter> getQueryParameters() {
        return Collections.unmodifiableList(this.queryParameters);
    }

    public abstract String getEndpoint();

    protected abstract Type getTypeForGson();

    public void addQueryParameter(String name, String value) {
        this.addQueryParameter(new QueryParameter(name, value));
    }

    public void addQueryParameter(String name, boolean value) {
        this.addQueryParameter(new QueryParameter(name, value));
    }

    public void addQueryParameter(String name, long value) {
        this.addQueryParameter(new QueryParameter(name, value));
    }

    public void addQueryParameter(String name, DateTime value) {
        this.addQueryParameter(new QueryParameter(name, value.getMillis()));
    }

    public void addQueryParameter(QueryParameter queryParameter) {
        this.queryParameters.add(queryParameter);
    }

    public String buildUrl() {
        return this.buildUrl(this.queryParameters);
    }

    protected String buildUrl(List<QueryParameter> queryParameters) {
        LinkedList<QueryParameter> params = new LinkedList<QueryParameter>(queryParameters);
        params.add(new QueryParameter("access_token", this.accessToken));
        StringBuffer url = new StringBuffer();
        url.append(this.getEndpoint());
        url.append("?");
        Iterator paramIter = params.iterator();
        while (paramIter.hasNext()) {
            String param = ((QueryParameter)paramIter.next()).toString();
            url.append(param);
            if (!paramIter.hasNext()) continue;
            url.append("&");
        }
        return url.toString();
    }

    public Response<T> call() {
        try {
            String url = this.buildUrl();
            LOG.debug("Calling URL: {}", (Object)url);
            URLConnection conn = new URL(url).openConnection();
            conn.connect();
            StringBuffer respBuf = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                respBuf.append(line);
            }
            String resp = respBuf.toString();
            LOG.trace("Response received: {}", (Object)resp);
            try {
                return this.deserializeFull(resp);
            }
            catch (JsonParseException e) {
                return this.deserializePartial(resp);
            }
        }
        catch (IOException e) {
            throw new BitlyClientException(e);
        }
    }

    private Response<T> deserializeFull(String resp) {
        return (Response)GSON.fromJson(resp, this.getTypeForGson());
    }

    private Response<T> deserializePartial(String resp) {
        ResponsePartial partial = (ResponsePartial)GSON.fromJson(resp, ResponsePartial.class);
        Response full = new Response();
        full.data = null;
        full.deserialize_error = true;
        full.status_code = partial.status_code;
        full.status_txt = partial.status_txt;
        return full;
    }
}

