/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaLoadCmd
implements Command {
    private static final String[] validOpts = new String[]{"-classpath"};

    JavaLoadCmd() {
    }

    /*
     * WARNING - void declaration
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        TclClassLoader tclClassLoader;
        String packageName;
        TclObject classpath;
        Extension pkg = null;
        boolean validLoad = false;
        if (argv.length != 2 && argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "?-classpath arg? packageName");
        }
        if (argv.length == 4) {
            TclIndex.get(interp, argv[1], validOpts, "switch", 0);
            classpath = argv[2];
            packageName = argv[3].toString();
        } else {
            classpath = null;
            packageName = argv[1].toString();
        }
        String errorMsg = "load \"" + packageName + "\" failed: ";
        if (packageName.endsWith(".class")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(".class"));
        }
        if (classpath == null) {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
        } else {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
            tclClassLoader = new TclClassLoader(interp, classpath, tclClassLoader);
        }
        try {
            validLoad = false;
            Class pkgClass = tclClassLoader.loadClass(packageName);
            validLoad = true;
        }
        catch (ClassNotFoundException e) {
            throw new TclException(interp, "package \"" + packageName + "\" not found");
        }
        catch (ClassFormatError e) {
            throw new TclException(interp, errorMsg + "use the fully qualified package name");
        }
        catch (PackageNameException e) {
            throw new TclException(interp, errorMsg + e);
        }
        finally {
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
        try {
            void var6_9;
            validLoad = false;
            pkg = (Extension)var6_9.newInstance();
            pkg.init(interp);
            validLoad = true;
        }
        catch (IllegalAccessException e) {
            throw new TclException(interp, errorMsg + "class or initializer is not accessible");
        }
        catch (InstantiationException e) {
            throw new TclException(interp, errorMsg + "object instantiation failure");
        }
        catch (ClassCastException e) {
            throw new TclException(interp, errorMsg + "not a subclass of tcl.lang.Extension");
        }
        catch (Exception e) {
            throw new TclException(interp, errorMsg + "can't find class \"" + e.getMessage() + "\"");
        }
        catch (LinkageError e) {
            throw new TclException(interp, "Extension \"" + packageName + "\" contains a dependency \"" + e.getMessage() + "\" that could not be resolved.");
        }
        finally {
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
    }
}

