/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import net.sf.swarmcache.ObjectCache;
import net.sf.swarmcache.UnboundedLRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerCache
implements ObjectCache,
Runnable {
    Log log = LogFactory.getLog(this.getClass());
    public static final String CACHE_TIMEOUT_PROPERTY = "cache.timeout";
    public static final int DEFAULT_CACHE_TIMEOUT = 10000;
    private String type;
    private long deadline = Long.MAX_VALUE;
    private boolean running = true;
    private Thread thread;
    private long timeout = 10000L;
    private UnboundedLRUMap cache;

    public TimerCache() {
        String property = System.getProperty(CACHE_TIMEOUT_PROPERTY);
        if (property != null) {
            try {
                this.timeout = Long.parseLong(property);
            }
            catch (NumberFormatException nfe) {
                this.log.warn((Object)"Cache timeout was improperly specified.");
                nfe.printStackTrace();
            }
        }
        this.cache = new UnboundedLRUMap();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void setTimeout(long newTimeout) {
        this.timeout = newTimeout;
    }

    public synchronized void stop() {
        this.running = false;
        this.notify();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.log.debug((Object)("Cache type set to '" + type + "'."));
        this.type = type;
        this.thread.setName("TimerCache-" + type);
    }

    public void put(Serializable key, Object object) {
        if (object == null) {
            this.clear(key);
        } else {
            TStampObject tobj = new TStampObject();
            tobj.object = object;
            tobj.time = System.currentTimeMillis() + this.timeout;
            this.cache.put(key, tobj);
            this.setDeadline(tobj.time);
            this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
        }
    }

    public Object get(Serializable key) {
        TStampObject tobj = (TStampObject)this.cache.get(key);
        if (tobj != null) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
            tobj.time = System.currentTimeMillis() + this.timeout;
            return tobj.object;
        }
        return null;
    }

    public Object clear(Serializable key) {
        this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        return this.cache.remove(key);
    }

    public void clearAll() {
        this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        this.cache.clear();
    }

    private synchronized void setDeadline(long time) {
        if (time < this.deadline) {
            this.deadline = time;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            try {
                TimerCache timerCache = this;
                synchronized (timerCache) {
                    long now = System.currentTimeMillis();
                    long waitTime = this.deadline - now;
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
            this.trimQueue();
        }
    }

    private void trimQueue() {
        this.log.debug((Object)"Waking up.");
        Object key = this.cache.getFirstKey();
        TStampObject tobj = (TStampObject)this.cache.get(key);
        if (tobj != null) {
            long now = System.currentTimeMillis();
            while (tobj != null && tobj.time <= now) {
                this.cache.remove(key);
                this.log.debug((Object)("Timed out object with key '" + key + "'."));
                key = this.cache.getFirstKey();
                tobj = (TStampObject)this.cache.get(key);
            }
        }
        this.deadline = tobj != null ? tobj.time : Long.MAX_VALUE;
        this.log.debug((Object)"Sleeping.");
    }

    static class TStampObject {
        public long time;
        public Object object;

        TStampObject() {
        }
    }
}

