/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Vector;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.UnsafeAccess;
import java9.util.function.Consumer;
import sun.misc.Unsafe;

final class VectorSpliterator<E>
implements Spliterator<E> {
    private final Vector<E> list;
    private Object[] array;
    private int index;
    private int fence;
    private int expectedModCount;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long DATA_OFF;

    private VectorSpliterator(Vector<E> list, Object[] array, int origin, int fence, int expectedModCount) {
        this.list = list;
        this.array = array;
        this.index = origin;
        this.fence = fence;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(Vector<T> vec) {
        return new VectorSpliterator<T>(vec, null, 0, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            Vector<E> vector = this.list;
            synchronized (vector) {
                this.array = VectorSpliterator.getData(this.list);
                this.expectedModCount = VectorSpliterator.getModCount(this.list);
                hi = this.fence = VectorSpliterator.getSize(this.list);
            }
        }
        return hi;
    }

    @Override
    public Spliterator<E> trySplit() {
        VectorSpliterator<E> vectorSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            vectorSpliterator = null;
        } else {
            this.index = mid;
            VectorSpliterator<E> vectorSpliterator2 = new VectorSpliterator<E>(this.list, this.array, lo, this.index, this.expectedModCount);
            vectorSpliterator = vectorSpliterator2;
        }
        return vectorSpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int i = this.index;
        if (this.getFence() > i) {
            this.index = i + 1;
            action.accept(this.array[i]);
            if (this.expectedModCount != VectorSpliterator.getModCount(this.list)) {
                throw new ConcurrentModificationException();
            }
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int hi = this.getFence();
        Object[] a = this.array;
        this.index = hi;
        for (int i = this.index; i < hi; ++i) {
            action.accept(a[i]);
        }
        if (VectorSpliterator.getModCount(this.list) != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    private static <T> int getSize(Vector<T> lst) {
        return U.getInt(lst, SIZE_OFF);
    }

    private static <T> int getModCount(Vector<T> lst) {
        return U.getInt(lst, MODCOUNT_OFF);
    }

    private static <T> Object[] getData(Vector<T> lst) {
        return (Object[])U.getObject(lst, DATA_OFF);
    }

    static {
        try {
            MODCOUNT_OFF = U.objectFieldOffset(AbstractList.class.getDeclaredField("modCount"));
            SIZE_OFF = U.objectFieldOffset(Vector.class.getDeclaredField("elementCount"));
            DATA_OFF = U.objectFieldOffset(Vector.class.getDeclaredField("elementData"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

