/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.Comparator;
import java9.util.J8Arrays;
import java9.util.Objects;
import java9.util.Optional;
import java9.util.Spliterators;
import java9.util.function.BiConsumer;
import java9.util.function.BiFunction;
import java9.util.function.BinaryOperator;
import java9.util.function.Consumer;
import java9.util.function.Function;
import java9.util.function.IntFunction;
import java9.util.function.Predicate;
import java9.util.function.Supplier;
import java9.util.function.ToDoubleFunction;
import java9.util.function.ToIntFunction;
import java9.util.function.ToLongFunction;
import java9.util.function.UnaryOperator;
import java9.util.stream.BaseStream;
import java9.util.stream.Collector;
import java9.util.stream.DoubleStream;
import java9.util.stream.IntStream;
import java9.util.stream.LongStream;
import java9.util.stream.StreamSpliterators;
import java9.util.stream.StreamSupport;
import java9.util.stream.Streams;
import java9.util.stream.WhileOps;

public interface Stream<T>
extends BaseStream<T, Stream<T>> {
    public Stream<T> filter(Predicate<? super T> var1);

    public <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public IntStream mapToInt(ToIntFunction<? super T> var1);

    public LongStream mapToLong(ToLongFunction<? super T> var1);

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    public Stream<T> distinct();

    public Stream<T> sorted();

    public Stream<T> sorted(Comparator<? super T> var1);

    public Stream<T> peek(Consumer<? super T> var1);

    public Stream<T> limit(long var1);

    public Stream<T> skip(long var1);

    default public Stream<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return (Stream)StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Taking<T>(this.spliterator(), true, predicate), this.isParallel()).onClose(StreamSupport.closeHandler(this));
    }

    default public Stream<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return (Stream)StreamSupport.stream(new WhileOps.UnorderedWhileSpliterator.OfRef.Dropping<T>(this.spliterator(), true, predicate), this.isParallel()).onClose(StreamSupport.closeHandler(this));
    }

    public void forEach(Consumer<? super T> var1);

    public void forEachOrdered(Consumer<? super T> var1);

    public Object[] toArray();

    public <A> A[] toArray(IntFunction<A[]> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public Optional<T> min(Comparator<? super T> var1);

    public Optional<T> max(Comparator<? super T> var1);

    public long count();

    public boolean anyMatch(Predicate<? super T> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Optional<T> findFirst();

    public Optional<T> findAny();

    public static <T> Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? Stream.empty() : StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> of(T ... values) {
        return J8Arrays.stream(values);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final UnaryOperator<S> f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.started) {
                    s = f.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final Predicate<S> hasNext, final UnaryOperator<S> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    s = next.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                if (!hasNext.test(s)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object s = this.started ? next.apply(this.prev) : seed;
                this.prev = null;
                while (hasNext.test(s)) {
                    action.accept(s);
                    s = next.apply(s);
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> generate(Supplier<? extends T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a.spliterator(), b.spliterator());
        Stream stream = StreamSupport.stream(split, a.isParallel() || b.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a, b));
    }

    public static interface Builder<T>
    extends Consumer<T> {
        @Override
        public void accept(T var1);

        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        public Stream<T> build();
    }
}

