/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.concurrent.ForkJoinPool;
import java9.util.function.IntFunction;
import java9.util.stream.AbstractPipeline;
import java9.util.stream.ForEachOps;
import java9.util.stream.Node;
import java9.util.stream.Nodes;
import java9.util.stream.PipelineHelper;
import java9.util.stream.ReduceOps;
import java9.util.stream.ReferencePipeline;
import java9.util.stream.Sink;
import java9.util.stream.StreamOpFlag;
import java9.util.stream.StreamShape;
import java9.util.stream.StreamSpliterators;
import java9.util.stream.TerminalOp;

final class DistinctOps {
    private DistinctOps() {
    }

    static <T> ReferencePipeline<T, T> makeRef(AbstractPipeline<?, T, ?> upstream) {
        return new ReferencePipeline.StatefulOp<T, T>(upstream, StreamShape.REFERENCE, StreamOpFlag.IS_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            <P_IN> Node<T> reduce(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                TerminalOp<Object, LinkedHashSet> reduceOp = ReduceOps.makeRef(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
                return Nodes.node(reduceOp.evaluateParallel(helper, spliterator));
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.evaluate(spliterator, false, generator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator);
                }
                AtomicBoolean seenNull = new AtomicBoolean(false);
                ConcurrentHashMap map = new ConcurrentHashMap(512, 0.75f, ForkJoinPool.getCommonPoolParallelism() + 1);
                TerminalOp<Object, Void> forEachOp = ForEachOps.makeRef(t -> {
                    if (t == null) {
                        seenNull.set(true);
                    } else {
                        map.putIfAbsent(t, Boolean.TRUE);
                    }
                }, false);
                forEachOp.evaluateParallel(helper, spliterator);
                Set keys = map.keySet();
                if (seenNull.get()) {
                    int size = keys.size();
                    if (size >= 127) {
                        keys = new KeysAndNullSet(keys, size);
                    } else {
                        HashSet tmp = new HashSet(Math.max((int)((float)(size + 1) / 0.75f) + 1, 16));
                        tmp.addAll(keys);
                        tmp.add(null);
                        keys = tmp;
                    }
                }
                return Nodes.node(keys);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.DISTINCT.isKnown(helper.getStreamAndOpFlags())) {
                    return helper.wrapSpliterator(spliterator);
                }
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.reduce(helper, spliterator).spliterator();
                }
                return new StreamSpliterators.DistinctSpliterator(helper.wrapSpliterator(spliterator));
            }

            @Override
            Sink<T> opWrapSink(int flags, Sink<T> sink) {
                Objects.requireNonNull(sink);
                if (StreamOpFlag.DISTINCT.isKnown(flags)) {
                    return sink;
                }
                if (StreamOpFlag.SORTED.isKnown(flags)) {
                    return new Sink.ChainedReference<T, T>(sink){
                        boolean seenNull;
                        T lastSeen;

                        @Override
                        public void begin(long size) {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.begin(-1L);
                        }

                        @Override
                        public void end() {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.end();
                        }

                        @Override
                        public void accept(T t) {
                            if (t == null) {
                                if (!this.seenNull) {
                                    this.seenNull = true;
                                    this.lastSeen = null;
                                    this.downstream.accept(null);
                                }
                            } else if (this.lastSeen == null || !t.equals(this.lastSeen)) {
                                this.lastSeen = t;
                                this.downstream.accept(this.lastSeen);
                            }
                        }
                    };
                }
                return new Sink.ChainedReference<T, T>(sink){
                    Set<T> seen;

                    @Override
                    public void begin(long size) {
                        this.seen = new HashSet();
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void end() {
                        this.seen = null;
                        this.downstream.end();
                    }

                    @Override
                    public void accept(T t) {
                        if (!this.seen.contains(t)) {
                            this.seen.add(t);
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }

    static final class KeysAndNullSet<E>
    extends AbstractSet<E> {
        final Set<E> keys;
        final int size;

        KeysAndNullSet(Set<E> keys, int size) {
            this.keys = keys;
            this.size = size + 1;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                boolean nullDelivered = false;
                final Iterator<E> it;
                {
                    this.it = keys.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (!this.nullDelivered) {
                        return true;
                    }
                    return this.it.hasNext();
                }

                @Override
                public E next() {
                    if (!this.nullDelivered) {
                        this.nullDelivered = true;
                        return null;
                    }
                    return this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

