/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java9.util.DoubleSummaryStatistics;
import java9.util.IntSummaryStatistics;
import java9.util.LongSummaryStatistics;
import java9.util.Maps;
import java9.util.Objects;
import java9.util.Optional;
import java9.util.StringJoiner;
import java9.util.concurrent.ConcurrentMaps;
import java9.util.function.BiConsumer;
import java9.util.function.BinaryOperator;
import java9.util.function.Consumer;
import java9.util.function.Function;
import java9.util.function.Predicate;
import java9.util.function.Supplier;
import java9.util.function.ToDoubleFunction;
import java9.util.function.ToIntFunction;
import java9.util.function.ToLongFunction;
import java9.util.stream.Collector;
import java9.util.stream.Stream;

public final class Collectors {
    static final Set<Collector.Characteristics> CH_CONCURRENT_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_CONCURRENT_NOID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED));
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private Collectors() {
    }

    private static <K, V> Supplier<Map<K, V>> hashMapFactory() {
        return HashMap::new;
    }

    private static <K, V> Supplier<ConcurrentMap<K, V>> concurrentHashMapFactory() {
        return ConcurrentHashMap::new;
    }

    private static IllegalStateException duplicateKeyException(Object k, Object u, Object v) {
        return new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", k, u, v));
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> uniqKeysMapMerger() {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Object k = e.getKey();
                Object v = Objects.requireNonNull(e.getValue());
                Object u = null;
                u = m1 instanceof ConcurrentMap ? ((ConcurrentMap)m1).putIfAbsent(k, v) : Maps.putIfAbsent(m1, k, v);
                if (u == null) continue;
                throw Collectors.duplicateKeyException(k, u, v);
            }
            return m1;
        };
    }

    private static <T, K, V> BiConsumer<Map<K, V>, T> uniqKeysMapAccumulator(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return (map, element) -> {
            Object k = keyMapper.apply(element);
            Object v = Objects.requireNonNull(valueMapper.apply(element));
            Object u = null;
            u = map instanceof ConcurrentMap ? ((ConcurrentMap)map).putIfAbsent(k, v) : Maps.putIfAbsent(map, k, v);
            if (u != null) {
                throw Collectors.duplicateKeyException(k, u, v);
            }
        };
    }

    public static <T, C extends Collection<T>> Collector<T, ?, C> toCollection(Supplier<C> collectionFactory) {
        return new CollectorImpl(collectionFactory, Collection::add, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, List<T>> toList() {
        return new CollectorImpl(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, Set<T>> toSet() {
        return new CollectorImpl(HashSet::new, Set::add, (left, right) -> {
            if (left.size() < right.size()) {
                right.addAll(left);
                return right;
            }
            left.addAll(right);
            return left;
        }, CH_UNORDERED_ID);
    }

    public static Collector<CharSequence, ?, String> joining() {
        return new CollectorImpl<CharSequence, StringBuilder, String>(StringBuilder::new, StringBuilder::append, (r1, r2) -> {
            r1.append((CharSequence)r2);
            return r1;
        }, StringBuilder::toString, CH_NOID);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return Collectors.joining(delimiter, "", "");
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new CollectorImpl<CharSequence, StringJoiner, String>(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, CH_NOID);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Maps.merge(m1, e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static <K, V, M extends ConcurrentMap<K, V>> BinaryOperator<M> mapMergerConcurrent(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                ConcurrentMaps.merge(m1, e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    public static <T, U, A, R> Collector<T, ?, R> mapping(Function<? super T, ? extends U> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> downstreamAccumulator.accept((Object)r, (Object)mapper.apply(t)), downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> {
            Stream result = null;
            try {
                result = (Stream)mapper.apply(t);
                if (result != null) {
                    ((Stream)result.sequential()).forEach(u -> downstreamAccumulator.accept(r, u));
                }
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new CollectorImpl<Object, Object, R>(downstream.supplier(), (r, t) -> {
            if (predicate.test(t)) {
                downstreamAccumulator.accept(r, t);
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, A, R, RR> Collector<T, A, RR> collectingAndThen(Collector<T, A, R> downstream, Function<R, RR> finisher) {
        Set<Collector.Characteristics> characteristics = downstream.characteristics();
        if (characteristics.contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            if (characteristics.size() == 1) {
                characteristics = CH_NOID;
            } else {
                characteristics = EnumSet.copyOf(characteristics);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                characteristics = Collections.unmodifiableSet(characteristics);
            }
        }
        return new CollectorImpl<T, A, RR>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher), characteristics);
    }

    public static <T> Collector<T, ?, Long> counting() {
        return Collectors.summingLong(e -> 1L);
    }

    public static <T> Collector<T, ?, Optional<T>> minBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.minBy(comparator));
    }

    public static <T> Collector<T, ?, Optional<T>> maxBy(Comparator<? super T> comparator) {
        return Collectors.reducing(BinaryOperator.maxBy(comparator));
    }

    public static <T> Collector<T, ?, Integer> summingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl<Object, int[], Integer>(() -> new int[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsInt(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Long> summingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Long>(() -> new long[1], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> summingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[3], (a, t) -> {
            double val = mapper.applyAsDouble(t);
            Collectors.sumWithCompensation(a, val);
            a[2] = a[2] + val;
        }, (a, b) -> {
            Collectors.sumWithCompensation(a, b[0]);
            a[2] = a[2] + b[2];
            return Collectors.sumWithCompensation(a, b[1]);
        }, a -> Collectors.computeFinalSum(a), CH_NOID);
    }

    static double[] sumWithCompensation(double[] intermediateSum, double value) {
        double tmp = value - intermediateSum[1];
        double sum = intermediateSum[0];
        double velvel = sum + tmp;
        intermediateSum[1] = velvel - sum - tmp;
        intermediateSum[0] = velvel;
        return intermediateSum;
    }

    static double computeFinalSum(double[] summands) {
        double tmp = summands[0] + summands[1];
        double simpleSum = summands[summands.length - 1];
        if (Double.isNaN(tmp) && Double.isInfinite(simpleSum)) {
            return simpleSum;
        }
        return tmp;
    }

    public static <T> Collector<T, ?, Double> averagingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + (long)mapper.applyAsInt(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl<Object, long[], Double>(() -> new long[2], (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
            a[1] = a[1] + 1L;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
            return a;
        }, a -> a[1] == 0L ? 0.0 : (double)a[0] / (double)a[1], CH_NOID);
    }

    public static <T> Collector<T, ?, Double> averagingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl<Object, double[], Double>(() -> new double[4], (a, t) -> {
            double val = mapper.applyAsDouble(t);
            Collectors.sumWithCompensation(a, val);
            a[2] = a[2] + 1.0;
            a[3] = a[3] + val;
        }, (a, b) -> {
            Collectors.sumWithCompensation(a, b[0]);
            Collectors.sumWithCompensation(a, b[1]);
            a[2] = a[2] + b[2];
            a[3] = a[3] + b[3];
            return a;
        }, a -> a[2] == 0.0 ? 0.0 : Collectors.computeFinalSum(a) / a[2], CH_NOID);
    }

    public static <T> Collector<T, ?, T> reducing(T identity, BinaryOperator<T> op) {
        return new CollectorImpl<Object, Object[], Object>(Collectors.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], t);
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    private static <T> Supplier<T[]> boxSupplier(T identity) {
        return () -> new Object[]{identity};
    }

    public static <T> Collector<T, ?, Optional<T>> reducing(BinaryOperator<T> op) {
        class OptionalBox
        implements Consumer<T> {
            T value = null;
            boolean present = false;
            final /* synthetic */ BinaryOperator val$op;

            OptionalBox(BinaryOperator binaryOperator) {
                this.val$op = binaryOperator;
            }

            @Override
            public void accept(T t) {
                if (this.present) {
                    this.value = this.val$op.apply(this.value, t);
                } else {
                    this.value = t;
                    this.present = true;
                }
            }
        }
        return new CollectorImpl<Object, OptionalBox, Optional>(() -> new OptionalBox(op), OptionalBox::accept, (a, b) -> {
            if (b.present) {
                a.accept(b.value);
            }
            return a;
        }, a -> Optional.ofNullable(a.value), CH_NOID);
    }

    public static <T, U> Collector<T, ?, U> reducing(U identity, Function<? super T, ? extends U> mapper, BinaryOperator<U> op) {
        return new CollectorImpl<Object, Object[], Object>(Collectors.boxSupplier(identity), (a, t) -> {
            a[0] = op.apply(a[0], mapper.apply(t));
        }, (a, b) -> {
            a[0] = op.apply(a[0], b[0]);
            return a;
        }, a -> a[0], CH_NOID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingBy(classifier, Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collectors.groupingBy(classifier, Collectors.hashMapFactory(), downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object container = Maps.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            downstreamAccumulator.accept(container, t);
        };
        BinaryOperator<M> merger = Collectors.mapMerger(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, merger, CH_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            Maps.replaceAll(intermediate, (k, v) -> downstreamFinisher.apply(v));
            Map castResult = intermediate;
            return castResult;
        };
        return new CollectorImpl<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K> Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> classifier) {
        return Collectors.groupingByConcurrent(classifier, Collectors.concurrentHashMapFactory(), Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Collectors.groupingByConcurrent(classifier, Collectors.concurrentHashMapFactory(), downstream);
    }

    public static <T, K, A, D, M extends ConcurrentMap<K, D>> Collector<T, ?, M> groupingByConcurrent(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BinaryOperator<M> merger = Collectors.mapMergerConcurrent(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        BiConsumer<ConcurrentMap, Object> accumulator = downstream.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) ? (m, t) -> {
            Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object resultContainer = ConcurrentMaps.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            downstreamAccumulator.accept(resultContainer, t);
        } : (m, t) -> {
            Object resultContainer;
            Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
            Object object = resultContainer = ConcurrentMaps.computeIfAbsent(m, key, k -> downstreamSupplier.get());
            synchronized (object) {
                downstreamAccumulator.accept(resultContainer, t);
            }
        };
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, merger, CH_CONCURRENT_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        Function<ConcurrentMap, ConcurrentMap> finisher = intermediate -> {
            ConcurrentMaps.replaceAll(intermediate, (k, v) -> downstreamFinisher.apply(v));
            ConcurrentMap castResult = intermediate;
            return castResult;
        };
        return new CollectorImpl<Object, ConcurrentMap, ConcurrentMap>(mangledFactory, accumulator, merger, finisher, CH_CONCURRENT_NOID);
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(Predicate<? super T> predicate) {
        return Collectors.partitioningBy(predicate, Collectors.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<? super T, A, D> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Partition, Object> accumulator = (result, t) -> downstreamAccumulator.accept((Object)(predicate.test(t) ? result.forTrue : result.forFalse), (Object)t);
        BinaryOperator op = downstream.combiner();
        BinaryOperator merger = (left, right) -> new Partition(op.apply(left.forTrue, right.forTrue), op.apply(left.forFalse, right.forFalse));
        Supplier<Partition> supplier = () -> new Partition(downstream.supplier().get(), downstream.supplier().get());
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(supplier, accumulator, merger, CH_ID);
        }
        Function<Partition, Map> finisher = par -> new Partition(downstream.finisher().apply(par.forTrue), downstream.finisher().apply(par.forFalse));
        return new CollectorImpl<Object, Partition, Map>(supplier, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return new CollectorImpl(Collectors.hashMapFactory(), Collectors.uniqKeysMapAccumulator(keyMapper, valueMapper), Collectors.uniqKeysMapMerger(), CH_ID);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toMap(keyMapper, valueMapper, mergeFunction, Collectors.hashMapFactory());
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapFactory) {
        BiConsumer<Map, Object> accumulator = (map, element) -> Maps.merge(map, keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapFactory, accumulator, Collectors.mapMerger(mergeFunction), CH_ID);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return new CollectorImpl(ConcurrentHashMap::new, Collectors.uniqKeysMapAccumulator(keyMapper, valueMapper), Collectors.uniqKeysMapMerger(), CH_CONCURRENT_ID);
    }

    public static <T, K, U> Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction, Collectors.concurrentHashMapFactory());
    }

    public static <T, K, U, M extends ConcurrentMap<K, U>> Collector<T, ?, M> toConcurrentMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapFactory) {
        BiConsumer<ConcurrentMap, Object> accumulator = (map, element) -> ConcurrentMaps.merge(map, keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapFactory, accumulator, Collectors.mapMergerConcurrent(mergeFunction), CH_CONCURRENT_ID);
    }

    public static <T> Collector<T, ?, IntSummaryStatistics> summarizingInt(ToIntFunction<? super T> mapper) {
        return new CollectorImpl(IntSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsInt(t)), (l, r) -> {
            l.combine((IntSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, LongSummaryStatistics> summarizingLong(ToLongFunction<? super T> mapper) {
        return new CollectorImpl(LongSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsLong(t)), (l, r) -> {
            l.combine((LongSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    public static <T> Collector<T, ?, DoubleSummaryStatistics> summarizingDouble(ToDoubleFunction<? super T> mapper) {
        return new CollectorImpl(DoubleSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsDouble(t)), (l, r) -> {
            l.combine((DoubleSummaryStatistics)r);
            return l;
        }, CH_ID);
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T forTrue, T forFalse) {
            this.forTrue = forTrue;
            this.forFalse = forFalse;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    AbstractMap.SimpleImmutableEntry falseEntry = new AbstractMap.SimpleImmutableEntry(false, forFalse);
                    AbstractMap.SimpleImmutableEntry trueEntry = new AbstractMap.SimpleImmutableEntry(true, forTrue);
                    return Arrays.asList(falseEntry, trueEntry).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof Boolean;
        }

        @Override
        public T get(Object key) {
            return key instanceof Boolean ? (((Boolean)key).booleanValue() ? (T)this.forTrue : (T)this.forFalse) : null;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, a -> a, characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

