/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.ast;

import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.ast.VmParser;
import net.sourceforge.pmd.lang.vm.ast.VmParserVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class ASTMethod
extends AbstractVmNode {
    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(VmParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(VmParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getMethodName() {
        return "";
    }

    public static class MethodCacheKey {
        private final String methodName;
        private final Class<?>[] params;

        public MethodCacheKey(String methodName, Class<?>[] params) {
            this.methodName = methodName != null ? methodName : "";
            this.params = params != null ? params : ArrayUtils.EMPTY_CLASS_ARRAY;
        }

        public boolean equals(Object o) {
            if (o instanceof MethodCacheKey) {
                MethodCacheKey other = (MethodCacheKey)o;
                if (this.params.length == other.params.length && this.methodName.equals(other.methodName)) {
                    for (int i = 0; i < this.params.length; ++i) {
                        if (!(this.params[i] == null ? this.params[i] != other.params[i] : !this.params[i].equals(other.params[i]))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            for (int i = 0; i < this.params.length; ++i) {
                Class<?> param = this.params[i];
                if (param == null) continue;
                result = result * 37 + param.hashCode();
            }
            result = result * 37 + this.methodName.hashCode();
            return result;
        }
    }
}

