/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.codestyle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class LineLengthRule
extends AbstractPLSQLRule {
    private static final PropertyDescriptor<Integer> MAX_LINE_LENGTH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLineLength").desc("The maximum allowed line length")).defaultValue((Object)80)).require(NumericConstraints.inRange((Number)10, (Number)200))).build();
    private static final PropertyDescriptor<Boolean> EACH_LINE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"eachLine").desc("Whether to report each line that is longer only the first line")).defaultValue((Object)false)).build();

    public LineLengthRule() {
        this.definePropertyDescriptor(MAX_LINE_LENGTH);
        this.definePropertyDescriptor(EACH_LINE);
        this.addRuleChainVisit(ASTInput.class);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        boolean eachLine = (Boolean)this.getProperty(EACH_LINE);
        int maxLineLength = (Integer)this.getProperty(MAX_LINE_LENGTH);
        try (BufferedReader in = new BufferedReader(new StringReader(node.getSourcecode()));){
            String line;
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                ++lineNumber;
                if (line.length() <= maxLineLength) continue;
                this.addViolationWithMessage(data, null, "The line is too long. Only " + maxLineLength + " characters are allowed.", lineNumber, lineNumber);
                if (eachLine) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing rule LineLengthRule", e);
        }
        return data;
    }
}

