/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.CaptureMatcher;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

abstract class TypeVarImpl
implements JTypeVar {
    final TypeSystem ts;
    JTypeMirror upperBound;
    final PSet<SymbolicValue.SymAnnot> typeAnnots;

    private TypeVarImpl(TypeSystem ts, PSet<SymbolicValue.SymAnnot> typeAnnots) {
        this.ts = ts;
        this.typeAnnots = Objects.requireNonNull(typeAnnots);
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return this.typeAnnots;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public JTypeMirror getErasure() {
        return this.getUpperBound().getErasure();
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    static CapturedTypeVar freshCapture(@NonNull JWildcardType wildcard) {
        return new CapturedTypeVar(wildcard, wildcard.getTypeAnnotations());
    }

    static JTypeVar tvarCapture(@NonNull JTypeVar tv) {
        if (tv.isCaptured()) {
            return tv;
        }
        JTypeMirror upperBoundCap = TypeConversion.capture(tv.getUpperBound());
        JTypeMirror lowerBoundCap = TypeConversion.capture(tv.getLowerBound());
        if (upperBoundCap == tv.getUpperBound() && lowerBoundCap == tv.getLowerBound()) {
            return tv;
        }
        CapturedTypeVar newTv = new CapturedTypeVar(tv, upperBoundCap, lowerBoundCap, tv.getTypeAnnotations());
        newTv.upperBound = (JTypeMirror)upperBoundCap.subst((T sv) -> TypeVarImpl.updateBounds(tv, sv, newTv));
        newTv.lowerBound = (JTypeMirror)lowerBoundCap.subst((T sv) -> TypeVarImpl.updateBounds(tv, sv, newTv));
        return newTv;
    }

    private static SubstVar updateBounds(JTypeVar tv, SubstVar sv, CapturedTypeVar newTv) {
        if (sv == tv) {
            return newTv;
        }
        if (sv instanceof JTypeVar) {
            return ((JTypeVar)sv).substInBounds(sv2 -> {
                if (sv2 == tv) {
                    return newTv;
                }
                return sv2;
            });
        }
        return sv;
    }

    static final class CapturedTypeVar
    extends TypeVarImpl {
        private static final int PRIME = 997;
        private final @Nullable JWildcardType wildcard;
        private final @Nullable JTypeVar tvar;
        private JTypeMirror upperBound;
        private JTypeMirror lowerBound;

        private CapturedTypeVar(@NonNull JWildcardType wild, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            this(wild, wild.asLowerBound(), wild.asUpperBound(), typeAnnots);
        }

        private CapturedTypeVar(@Nullable JWildcardType wild, @NonNull JTypeMirror lower, @NonNull JTypeMirror upper, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            super(lower.getTypeSystem(), typeAnnots);
            this.upperBound = upper;
            this.lowerBound = lower;
            this.wildcard = wild;
            this.tvar = null;
        }

        private CapturedTypeVar(@Nullable JTypeVar tvar, @NonNull JTypeMirror lower, @NonNull JTypeMirror upper, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            super(lower.getTypeSystem(), typeAnnots);
            this.upperBound = upper;
            this.lowerBound = lower;
            this.tvar = tvar;
            this.wildcard = null;
        }

        private CapturedTypeVar(@Nullable JTypeVar tvar, JWildcardType wild, @NonNull JTypeMirror lower, @NonNull JTypeMirror upper, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            super(lower.getTypeSystem(), typeAnnots);
            this.upperBound = upper;
            this.lowerBound = lower;
            this.tvar = tvar;
            this.wildcard = wild;
        }

        void setUpperBound(@NonNull JTypeMirror upperBound) {
            this.upperBound = upperBound;
        }

        void setLowerBound(@NonNull JTypeMirror lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof CaptureMatcher && o.equals(this);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public boolean isCaptureOf(JWildcardType wildcard) {
            return this.wildcard != null && this.wildcard.equals(wildcard);
        }

        @Override
        public JWildcardType getCapturedOrigin() {
            return this.wildcard;
        }

        @Override
        public JTypeVar substInBounds(Function<? super SubstVar, ? extends @NonNull JTypeMirror> substitution) {
            JTypeMirror wild = this.wildcard == null ? null : this.wildcard.subst((Function)substitution);
            JTypeVisitable lower = this.getLowerBound().subst((Function)substitution);
            JTypeVisitable upper = this.getUpperBound().subst((Function)substitution);
            if (wild == this.wildcard && lower == this.lowerBound && upper == this.lowerBound) {
                return this;
            }
            if (wild == null) {
                return new CapturedTypeVar(this.tvar, (JTypeMirror)lower, (JTypeMirror)upper, (PSet<SymbolicValue.SymAnnot>)this.typeAnnots);
            }
            return new CapturedTypeVar((JWildcardType)wild, (JTypeMirror)lower, (JTypeMirror)upper, this.getTypeAnnotations());
        }

        @Override
        public JTypeVar cloneWithBounds(JTypeMirror lower, JTypeMirror upper) {
            return new CapturedTypeVar(this.wildcard, lower, upper, this.getTypeAnnotations());
        }

        @Override
        public JTypeVar withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
            if (newTypeAnnots.isEmpty() && this.typeAnnots.isEmpty()) {
                return this;
            }
            return new CapturedTypeVar(this.tvar, this.wildcard, this.lowerBound, this.upperBound, newTypeAnnots);
        }

        @Override
        public JTypeVar withUpperBound(@NonNull JTypeMirror newUB) {
            throw new UnsupportedOperationException("This only needs to be implemented on regular type variables");
        }

        @Override
        public @NonNull JTypeMirror getUpperBound() {
            return this.upperBound;
        }

        @Override
        public @NonNull JTypeMirror getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public @Nullable JTypeParameterSymbol getSymbol() {
            return this.tvar == null ? null : this.tvar.getSymbol();
        }

        @Override
        public @NonNull String getName() {
            JTypeMirror captureOrigin = this.wildcard == null ? this.tvar : this.wildcard;
            return "capture#" + this.hashCode() % 997 + " of " + captureOrigin;
        }
    }

    static final class RegularTypeVar
    extends TypeVarImpl {
        private final @NonNull JTypeParameterSymbol symbol;

        RegularTypeVar(TypeSystem ts, @NonNull JTypeParameterSymbol symbol, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            super(ts, typeAnnots);
            this.symbol = symbol;
        }

        private RegularTypeVar(RegularTypeVar base, PSet<SymbolicValue.SymAnnot> typeAnnots) {
            this(base.ts, base.symbol, typeAnnots);
            this.upperBound = base.upperBound;
        }

        @Override
        public boolean isCaptured() {
            return false;
        }

        @Override
        public @NonNull JTypeMirror getLowerBound() {
            return this.ts.NULL_TYPE;
        }

        @Override
        public @NonNull JTypeParameterSymbol getSymbol() {
            return this.symbol;
        }

        @Override
        public @NonNull String getName() {
            return this.symbol.getSimpleName();
        }

        @Override
        public @NonNull JTypeMirror getUpperBound() {
            if (this.upperBound == null) {
                this.upperBound = this.symbol.computeUpperBound();
            }
            return this.upperBound;
        }

        @Override
        public JTypeVar withUpperBound(@NonNull JTypeMirror newUB) {
            RegularTypeVar tv = new RegularTypeVar(this, (PSet<SymbolicValue.SymAnnot>)this.typeAnnots);
            tv.upperBound = newUB;
            return tv;
        }

        @Override
        public JTypeVar withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
            if (newTypeAnnots.isEmpty() && this.typeAnnots.isEmpty()) {
                return this;
            }
            return new RegularTypeVar(this, newTypeAnnots);
        }

        @Override
        public JTypeVar substInBounds(Function<? super SubstVar, ? extends @NonNull JTypeMirror> substitution) {
            if (Substitution.isEmptySubst(substitution)) {
                return this;
            }
            JTypeVisitable newBound = this.getUpperBound().subst((Function)substitution);
            if (newBound == this.upperBound) {
                return this;
            }
            RegularTypeVar newTVar = new RegularTypeVar(this.ts, this.symbol, this.getTypeAnnotations());
            newTVar.upperBound = newBound;
            return newTVar;
        }

        @Override
        public JTypeVar cloneWithBounds(JTypeMirror lower, JTypeMirror upper) {
            throw new UnsupportedOperationException("Not a capture variable");
        }

        @Override
        public boolean isCaptureOf(JWildcardType wildcard) {
            return false;
        }

        @Override
        public @Nullable JWildcardType getCapturedOrigin() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegularTypeVar that = (RegularTypeVar)o;
            return this.symbol.equals(that.symbol);
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }
    }
}

