/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class ClassWithOnlyPrivateConstructorsShouldBeFinalRule
extends AbstractJavaRulechainRule {
    public ClassWithOnlyPrivateConstructorsShouldBeFinalRule() {
        super(ASTClassDeclaration.class, new Class[0]);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (node.isRegularClass() && !node.hasModifiers(JModifier.FINAL, new JModifier[0]) && !node.isAnnotationPresent("lombok.Value") && !this.hasPublicLombokConstructors(node) && this.hasOnlyPrivateCtors(node) && this.hasNoSubclasses(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return null;
    }

    private boolean hasPublicLombokConstructors(ASTClassDeclaration node) {
        return node.getDeclaredAnnotations().filter(it -> TypeTestUtil.isA("lombok.NoArgsConstructor", (TypeNode)it) || TypeTestUtil.isA("lombok.RequiredArgsConstructor", (TypeNode)it) || TypeTestUtil.isA("lombok.AllArgsConstructor", (TypeNode)it)).any(it -> it.getFlatValue("access").filterIs(ASTAssignableExpr.ASTNamedReferenceExpr.class).none(ref -> "PRIVATE".equals(ref.getName())));
    }

    private boolean hasNoSubclasses(ASTClassDeclaration klass) {
        return klass.getRoot().descendants(ASTTypeDeclaration.class).crossFindBoundaries().none(it -> this.doesExtend((ASTTypeDeclaration)it, klass));
    }

    private boolean doesExtend(ASTTypeDeclaration sub, ASTClassDeclaration superClass) {
        return sub != superClass && TypeTestUtil.isA((JTypeMirror)superClass.getTypeMirror().getErasure(), (TypeNode)sub);
    }

    private boolean hasOnlyPrivateCtors(ASTClassDeclaration node) {
        return node.getDeclarations(ASTConstructorDeclaration.class).all(it -> it.getVisibility() == ModifierOwner.Visibility.V_PRIVATE) && (node.getVisibility() == ModifierOwner.Visibility.V_PRIVATE || node.getDeclarations(ASTConstructorDeclaration.class).nonEmpty());
    }
}

