/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTImplicitClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTLocalClassStatement;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponentList;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTopLevelDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeBody;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.TypeParamOwnerNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ASTTypeDeclaration
extends TypeNode,
ModifierOwner,
TypeParamOwnerNode,
ASTBodyDeclaration,
ASTTopLevelDeclaration,
JavadocCommentOwner {
    @Override
    public @NonNull JClassSymbol getSymbol();

    @Override
    public @NonNull JClassType getTypeMirror();

    public @NonNull String getSimpleName();

    default public String getPackageName() {
        return this.getRoot().getPackageName();
    }

    public @NonNull String getBinaryName();

    public @Nullable String getCanonicalName();

    default public boolean isAbstract() {
        return this.hasModifiers(JModifier.ABSTRACT, new JModifier[0]);
    }

    default public boolean isStatic() {
        return this.hasModifiers(JModifier.STATIC, new JModifier[0]);
    }

    default public boolean isFinal() {
        return this.hasModifiers(JModifier.FINAL, new JModifier[0]);
    }

    default public NodeStream<ASTEnumConstant> getEnumConstants() {
        return ((ASTEnumBody)this.firstChild(ASTEnumBody.class)).children(ASTEnumConstant.class);
    }

    default public @Nullable ASTRecordComponentList getRecordComponents() {
        return null;
    }

    default public NodeStream<ASTBodyDeclaration> getDeclarations() {
        return this.getBody().toStream();
    }

    default public <T extends ASTBodyDeclaration> NodeStream<T> getDeclarations(Class<? extends T> klass) {
        return this.getDeclarations().filterIs(klass);
    }

    default public NodeStream<ASTExecutableDeclaration> getOperations() {
        return this.getDeclarations().filterIs(ASTExecutableDeclaration.class);
    }

    default public ASTTypeBody getBody() {
        return (ASTTypeBody)this.getLastChild();
    }

    default public boolean isNested() {
        return this.getParent() instanceof ASTTypeBody;
    }

    default public boolean isLocal() {
        return this.getParent() instanceof ASTLocalClassStatement;
    }

    default public boolean isTopLevel() {
        return this.getParent() instanceof ASTCompilationUnit;
    }

    default public boolean isAnonymous() {
        return this instanceof ASTAnonymousClassDeclaration;
    }

    default public boolean isUnnamedToplevelClass() {
        return this instanceof ASTImplicitClassDeclaration;
    }

    default public boolean isEnum() {
        return this instanceof ASTEnumDeclaration;
    }

    default public boolean isRecord() {
        return this instanceof ASTRecordDeclaration;
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isRegularClass() {
        return false;
    }

    default public boolean isRegularInterface() {
        return false;
    }

    default public boolean isAnnotation() {
        return this instanceof ASTAnnotationTypeDeclaration;
    }

    default public @NonNull NodeStream<ASTClassType> getSuperInterfaceTypeNodes() {
        return ASTList.orEmptyStream(this.isInterface() ? (ASTList)this.firstChild(ASTExtendsList.class) : (ASTList)this.firstChild(ASTImplementsList.class));
    }
}

