/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailedException;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ExprCheckHelper {
    private final InferenceContext infCtx;
    private final MethodResolutionPhase phase;
    private final ExprChecker checker;
    private final @Nullable MethodCallSite site;
    private final Infer infer;
    private final TypeSystem ts;

    ExprCheckHelper(InferenceContext infCtx, MethodResolutionPhase phase, ExprChecker checker, @Nullable MethodCallSite site, Infer infer) {
        this.infCtx = infCtx;
        this.phase = phase;
        this.checker = checker;
        this.site = site;
        this.infer = infer;
        this.ts = infer.getTypeSystem();
    }

    boolean isCompatible(JTypeMirror targetType, ExprMirror expr) {
        boolean isStandalone;
        JTypeMirror standalone = expr.getStandaloneType();
        if (standalone != null) {
            if (this.mayMutateExpr()) {
                expr.setInferredType(standalone);
                expr.finishStandaloneInference(standalone);
            }
            isStandalone = true;
            this.checker.checkExprConstraint(this.infCtx, standalone, targetType);
            if (!(expr instanceof ExprMirror.PolyExprMirror)) {
                return true;
            }
        } else {
            isStandalone = false;
        }
        if (expr instanceof ExprMirror.FunctionalExprMirror) {
            JClassType funType = this.getProbablyFunctItfType(targetType, expr);
            if (funType == null) {
                this.infer.LOG.functionalExprNeedsInvocationCtx(targetType, expr);
                return true;
            }
            if (expr instanceof ExprMirror.LambdaExprMirror) {
                ExprMirror.LambdaExprMirror lambda = (ExprMirror.LambdaExprMirror)expr;
                try {
                    return this.isLambdaCompatible(funType, lambda);
                }
                catch (ResolutionFailedException e) {
                    if (this.mayMutateExpr()) {
                        lambda.setInferredType(null);
                        lambda.setFunctionalMethod(null);
                    }
                    if (this.site != null) {
                        this.site.maySkipInvocation(false);
                    }
                    throw e;
                }
            }
            return this.isMethodRefCompatible(funType, (ExprMirror.MethodRefMirror)expr);
        }
        if (expr instanceof ExprMirror.InvocationMirror) {
            return this.isInvocationCompatible(targetType, (ExprMirror.InvocationMirror)expr, isStandalone);
        }
        if (expr instanceof ExprMirror.BranchingMirror) {
            return ((ExprMirror.BranchingMirror)expr).branchesMatch(it -> this.isCompatible(targetType, (ExprMirror)it));
        }
        return false;
    }

    private boolean isInvocationCompatible(JTypeMirror targetType, ExprMirror.InvocationMirror invoc, boolean isStandalone) {
        MethodCallSite nestedSite = this.infer.newCallSite(invoc, targetType, this.site, this.infCtx, this.isSpecificityCheck());
        ExprMirror.InvocationMirror.MethodCtDecl argCtDecl = this.infer.determineInvocationTypeOrFail(nestedSite);
        JMethodSig mostSpecific = argCtDecl.getMethodType();
        JTypeMirror actualType = mostSpecific.getReturnType();
        if (argCtDecl == this.infer.FAILED_INVOCATION) {
            throw ResolutionFailedException.incompatibleFormal(this.infer.LOG, invoc, this.ts.ERROR, targetType);
        }
        if (argCtDecl == this.infer.NO_CTDECL) {
            JTypeMirror fallback = invoc.unresolvedType();
            if (fallback != null) {
                actualType = fallback;
            }
            if (this.mayMutateExpr()) {
                invoc.setInferredType(fallback);
                invoc.setCtDecl(this.infer.NO_CTDECL);
            }
        }
        if (this.site != null) {
            this.site.maySkipInvocation(nestedSite.canSkipInvocation());
        }
        if (!isStandalone) {
            this.checker.checkExprConstraint(this.infCtx, actualType, targetType);
        }
        if (!argCtDecl.isFailed() && this.mayMutateExpr()) {
            this.infCtx.addInstantiationListener(this.infCtx.freeVarsIn(mostSpecific), solved -> {
                JMethodSig ground = solved.ground(mostSpecific);
                invoc.setInferredType(ground.getReturnType());
                invoc.setCtDecl(argCtDecl.withMethod(ground));
            });
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable JClassType getProbablyFunctItfType(JTypeMirror targetType, ExprMirror expr) {
        JClassType asClass;
        if (targetType instanceof InferenceVar && this.site != null) {
            if (!this.site.isInFinalInvocation()) return null;
            asClass = TypeOps.asClassType(this.softSolve(targetType));
        } else {
            asClass = TypeOps.asClassType(targetType);
        }
        if (asClass != null) return asClass;
        throw ResolutionFailedException.notAFunctionalInterface(this.infer.LOG, targetType, expr);
    }

    private @Nullable JTypeMirror softSolve(JTypeMirror t) {
        if (!(t instanceof InferenceVar)) {
            return t;
        }
        InferenceVar ivar = (InferenceVar)t;
        Set<JTypeMirror> bounds = ivar.getBounds(InferenceVar.BoundKind.EQ);
        if (bounds.size() == 1) {
            return bounds.iterator().next();
        }
        bounds = ivar.getBounds(InferenceVar.BoundKind.LOWER);
        if (!bounds.isEmpty()) {
            JTypeMirror lub = this.ts.lub(bounds);
            return lub != ivar ? this.softSolve(lub) : null;
        }
        bounds = ivar.getBounds(InferenceVar.BoundKind.UPPER);
        if (!bounds.isEmpty()) {
            JTypeMirror glb = this.ts.glb(bounds);
            return glb != ivar ? this.softSolve(glb) : null;
        }
        return null;
    }

    private boolean isMethodRefCompatible(@NonNull JClassType functionalItf, ExprMirror.MethodRefMirror mref) {
        JClassType nonWildcard = TypeOps.nonWildcardParameterization(functionalItf);
        if (nonWildcard == null) {
            throw ResolutionFailedException.notAFunctionalInterface(this.infer.LOG, functionalItf, mref);
        }
        JMethodSig fun = TypeOps.findFunctionalInterfaceMethod(nonWildcard);
        if (fun == null) {
            throw ResolutionFailedException.notAFunctionalInterface(this.infer.LOG, functionalItf, mref);
        }
        JMethodSig exactMethod = ExprOps.getExactMethod(mref);
        if (exactMethod != null) {
            JTypeMirror r;
            int k;
            List<JTypeMirror> ps = fun.getFormalParameters();
            List<JTypeMirror> fs = exactMethod.getFormalParameters();
            int n = ps.size();
            if (n == (k = fs.size()) + 1) {
                JTypeMirror lhs = mref.getLhsIfType();
                if (lhs == null) {
                    return false;
                }
                JTypeMirror receiver = ps.get(0);
                if (receiver.isPrimitive()) {
                    throw ResolutionFailedException.cannotInvokeInstanceMethodOnPrimitive(this.infer.LOG, receiver, mref);
                }
                this.checker.checkExprConstraint(this.infCtx, receiver, lhs);
                for (int i = 1; i < n; ++i) {
                    this.checker.checkExprConstraint(this.infCtx, ps.get(i), fs.get(i - 1));
                }
            } else {
                if (n != k) {
                    throw ResolutionFailedException.incompatibleArity(this.infer.LOG, k, n, mref);
                }
                for (int i = 0; i < n; ++i) {
                    this.checker.checkExprConstraint(this.infCtx, ps.get(i), fs.get(i));
                }
            }
            if ((r = fun.getReturnType()) != this.ts.NO_TYPE) {
                JTypeMirror r2 = exactMethod.getReturnType();
                if (r2 == this.ts.NO_TYPE) {
                    return false;
                }
                this.checker.checkExprConstraint(this.infCtx, TypeConversion.capture(r2), r);
            }
            this.completeMethodRefInference(mref, nonWildcard, fun, exactMethod, true);
        } else {
            this.infCtx.addInstantiationListener(this.infCtx.freeVarsIn(fun.getFormalParameters()), solvedCtx -> this.solveInexactMethodRefCompatibility(mref, solvedCtx.ground(nonWildcard), solvedCtx.ground(fun)));
        }
        return true;
    }

    private void solveInexactMethodRefCompatibility(ExprMirror.MethodRefMirror mref, JClassType nonWildcard, JMethodSig fun) {
        @Nullable ExprMirror.InvocationMirror.MethodCtDecl ctdecl0 = this.infer.exprOps.findInexactMethodRefCompileTimeDecl(mref, fun);
        if (ctdecl0 == null) {
            throw ResolutionFailedException.noCtDeclaration(this.infer.LOG, fun, mref);
        }
        JMethodSig ctdecl = ctdecl0.getMethodType();
        JTypeMirror r = fun.getReturnType();
        if (r == this.ts.NO_TYPE) {
            this.completeMethodRefInference(mref, nonWildcard, fun, ctdecl, false);
            return;
        }
        boolean fixInstantiation = false;
        if (mref.getExplicitTypeArguments().isEmpty() && ExprOps.isContextDependent(ctdecl)) {
            if (TypeOps.mentionsAny(r, fun.getTypeParameters())) {
                if (!TypeOps.haveSameTypeParams(ctdecl, fun)) {
                    throw ResolutionFailedException.unsolvableDependency(this.infer.LOG);
                }
                fixInstantiation = true;
            }
            if (this.phase.isInvocation()) {
                JTypeVisitable sig = this.inferMethodRefInvocation(mref, fun, ctdecl0);
                if (fixInstantiation) {
                    sig = sig.subst((Function)Substitution.mapping(fun.getTypeParameters(), sig.getTypeParameters()));
                }
                this.completeMethodRefInference(mref, nonWildcard, fun, (JMethodSig)sig, false);
            }
        } else {
            if (ctdecl.getReturnType() == this.ts.NO_TYPE) {
                throw ResolutionFailedException.incompatibleReturn(this.infer.LOG, mref, ctdecl.getReturnType(), r);
            }
            this.checker.checkExprConstraint(this.infCtx, TypeConversion.capture(ctdecl.getReturnType()), r);
            this.completeMethodRefInference(mref, nonWildcard, fun, ctdecl, false);
        }
    }

    private void completeMethodRefInference(ExprMirror.MethodRefMirror mref, JClassType groundTargetType, JMethodSig functionalMethod, JMethodSig ctDecl, boolean isExactMethod) {
        if ((this.phase.isInvocation() || isExactMethod) && this.mayMutateExpr()) {
            this.infCtx.addInstantiationListener(this.infCtx.freeVarsIn(groundTargetType), solved -> {
                mref.setInferredType(solved.ground(groundTargetType));
                mref.setFunctionalMethod(InternalMethodTypeItf.cast(solved.ground(functionalMethod)).withOwner(solved.ground(functionalMethod.getDeclaringType())));
                mref.setCompileTimeDecl(solved.ground(ctDecl));
            });
        }
    }

    JMethodSig inferMethodRefInvocation(ExprMirror.MethodRefMirror mref, JMethodSig targetType, ExprMirror.InvocationMirror.MethodCtDecl ctdecl) {
        ExprMirror.InvocationMirror wrapper = ExprOps.methodRefAsInvocation(mref, targetType, false);
        wrapper.setCtDecl(ctdecl);
        MethodCallSite mockSite = this.infer.newCallSite(wrapper, targetType.getReturnType(), this.site, this.infCtx, this.isSpecificityCheck());
        return this.infer.determineInvocationTypeOrFail(mockSite).getMethodType();
    }

    private boolean isLambdaCompatible(@NonNull JClassType functionalItf, ExprMirror.LambdaExprMirror lambda) {
        JClassType groundTargetType = this.groundTargetType(functionalItf, lambda);
        if (groundTargetType == null) {
            throw ResolutionFailedException.notAFunctionalInterface(this.infer.LOG, functionalItf, lambda);
        }
        JMethodSig groundFun = TypeOps.findFunctionalInterfaceMethod(groundTargetType);
        if (groundFun == null) {
            throw ResolutionFailedException.notAFunctionalInterface(this.infer.LOG, functionalItf, lambda);
        }
        if (this.mayMutateExpr()) {
            lambda.setInferredType(groundTargetType);
            lambda.setFunctionalMethod(groundFun);
            if (this.phase.isInvocation()) {
                this.infCtx.addInstantiationListener(this.infCtx.freeVarsIn(groundTargetType), solved -> {
                    JClassType solvedGround = solved.ground(groundTargetType);
                    lambda.setInferredType(solvedGround);
                    lambda.setFunctionalMethod(InternalMethodTypeItf.cast(solved.ground(groundFun)).withOwner(solved.ground(groundFun.getDeclaringType())));
                });
            }
        }
        return this.isLambdaCongruent(functionalItf, groundTargetType, groundFun, lambda);
    }

    private boolean mayMutateExpr() {
        return !this.isSpecificityCheck();
    }

    private boolean isSpecificityCheck() {
        return this.site != null && this.site.isSpecificityCheck();
    }

    private boolean isLambdaCongruent(@NonNull JClassType functionalItf, @NonNull JClassType groundTargetType, @NonNull JMethodSig groundFun, ExprMirror.LambdaExprMirror lambda) {
        if (groundFun.isGeneric()) {
            throw ResolutionFailedException.lambdaCannotTargetGenericFunction(this.infer.LOG, groundFun, lambda);
        }
        if (groundFun.getArity() != lambda.getParamCount()) {
            throw ResolutionFailedException.incompatibleArity(this.infer.LOG, lambda.getParamCount(), groundFun.getArity(), lambda);
        }
        JTypeMirror result = groundFun.getReturnType();
        if (result == this.ts.NO_TYPE && !lambda.isVoidCompatible()) {
            throw ResolutionFailedException.lambdaCannotTargetVoidMethod(this.infer.LOG, lambda);
        }
        if (result != this.ts.NO_TYPE && !lambda.isValueCompatible()) {
            throw ResolutionFailedException.lambdaCannotTargetValueMethod(this.infer.LOG, lambda);
        }
        if (lambda.isExplicitlyTyped() && !TypeOps.areSameTypesInInference(groundFun.getFormalParameters(), lambda.getExplicitParameterTypes())) {
            throw ResolutionFailedException.mismatchedLambdaParameters(this.infer.LOG, groundFun, lambda.getExplicitParameterTypes(), lambda);
        }
        if (result != this.ts.NO_TYPE) {
            this.infCtx.addInstantiationListener(this.infCtx.freeVarsIn(groundFun.getFormalParameters()), solvedCtx -> {
                if (this.mayMutateExpr()) {
                    lambda.setInferredType(solvedCtx.ground(groundTargetType));
                    JMethodSig solvedGroundFun = solvedCtx.ground(groundFun);
                    lambda.setFunctionalMethod(solvedGroundFun);
                    lambda.updateTypingContext(solvedGroundFun);
                }
                JTypeMirror groundResult = solvedCtx.ground(result);
                for (ExprMirror expr : lambda.getResultExpressions()) {
                    if (this.isCompatible(groundResult, expr)) continue;
                    return;
                }
            });
        }
        if (this.mayMutateExpr()) {
            lambda.updateTypingContext(groundFun);
        }
        return true;
    }

    private @Nullable JClassType groundTargetType(JClassType type, ExprMirror.LambdaExprMirror lambda) {
        List<JTypeMirror> targs = type.getTypeArgs();
        if (CollectionUtil.none(targs, it -> it instanceof JWildcardType)) {
            return type;
        }
        if (lambda.isExplicitlyTyped() && lambda.getParamCount() > 0) {
            return this.inferGroundTargetTypeForExplicitlyTypedLambda(type, lambda);
        }
        return TypeOps.nonWildcardParameterization(type);
    }

    private @Nullable JClassType inferGroundTargetTypeForExplicitlyTypedLambda(JClassType targetType, ExprMirror.LambdaExprMirror lambda) {
        List<JTypeMirror> explicitParamTypes = lambda.getExplicitParameterTypes();
        assert (explicitParamTypes != null) : "Expecting explicitly typed lambda";
        JClassType targetGTD = targetType.getGenericTypeDeclaration();
        List<JTypeVar> formalTypeParams = targetGTD.getFormalTypeParams();
        InferenceContext ctx = this.infer.newContextFor(formalTypeParams, false);
        JClassType inferenceTarget = (JClassType)ctx.mapToIVars(targetGTD);
        JMethodSig msig = TypeOps.findFunctionalInterfaceMethod(inferenceTarget);
        if (msig == null) {
            return null;
        }
        List<JTypeMirror> formals = msig.getFormalParameters();
        if (!TypeOps.areSameTypesInInference(formals, explicitParamTypes)) {
            return null;
        }
        ctx.solve(true);
        int numTyArgs = formalTypeParams.size();
        List<JTypeMirror> typeArgs = targetType.getTypeArgs();
        ArrayList<JTypeMirror> newTyArgs = new ArrayList<JTypeMirror>(numTyArgs);
        for (int i = 0; i < numTyArgs; ++i) {
            InferenceVar ivarI = (InferenceVar)ctx.mapToIVars(formalTypeParams.get(i));
            if (ivarI.getInst() != null) {
                newTyArgs.add(ivarI.getInst());
                continue;
            }
            newTyArgs.add(typeArgs.get(i));
        }
        ctx.addPrimaryBounds();
        ctx.solve();
        JClassType inferredTy = targetGTD.withTypeArguments(newTyArgs);
        return TypeOps.nonWildcardParameterization(inferredTy);
    }

    @FunctionalInterface
    static interface ExprChecker {
        public void checkExprConstraint(InferenceContext var1, JTypeMirror var2, JTypeMirror var3) throws ResolutionFailedException;
    }
}

