/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

public interface JTypeMirror
extends JTypeVisitable {
    public TypeSystem getTypeSystem();

    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations();

    default public boolean isSubtypeOf(@NonNull JTypeMirror other) {
        return this.isConvertibleTo(other).bySubtyping();
    }

    default public TypeOps.Convertibility isConvertibleTo(@NonNull JTypeMirror other) {
        return TypeOps.isConvertible(this, other);
    }

    default public Set<JTypeMirror> getSuperTypeSet() {
        return TypeOps.getSuperTypeSet(this);
    }

    default public JTypeMirror getErasure() {
        return this;
    }

    default public @Nullable JTypeDeclSymbol getSymbol() {
        return null;
    }

    default public JTypeMirror box() {
        return this;
    }

    default public JTypeMirror unbox() {
        return this;
    }

    default public @Nullable JTypeMirror getAsSuper(@NonNull JClassSymbol symbol) {
        return TypeOps.asSuper(this, symbol);
    }

    default public boolean isReifiable() {
        if (this instanceof JPrimitiveType) {
            return true;
        }
        if (this instanceof JArrayType) {
            return ((JArrayType)this).getElementType().isReifiable();
        }
        return this instanceof JClassType && TypeOps.allArgsAreUnboundedWildcards(((JClassType)this).getTypeArgs());
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean isPrimitive(JPrimitiveType.PrimitiveTypeKind kind) {
        return false;
    }

    default public boolean isFloatingPoint() {
        return false;
    }

    default public boolean isIntegral() {
        return false;
    }

    default public boolean isTypeVariable() {
        return this instanceof JTypeVar;
    }

    default public boolean isBoxedPrimitive() {
        return this.unbox() != this;
    }

    default public boolean isNumeric() {
        return false;
    }

    default public boolean isClassOrInterface() {
        return this instanceof JClassType;
    }

    default public boolean isTop() {
        return false;
    }

    default public boolean isBottom() {
        return false;
    }

    default public boolean isVoid() {
        return this == this.getTypeSystem().NO_TYPE;
    }

    default public boolean isArray() {
        return this instanceof JArrayType;
    }

    default public boolean isGenericTypeDeclaration() {
        return false;
    }

    default public boolean isGeneric() {
        return false;
    }

    default public boolean isParameterizedType() {
        return false;
    }

    default public boolean isRaw() {
        return false;
    }

    default public boolean isInterface() {
        JTypeDeclSymbol sym = this.getSymbol();
        return sym != null && sym.isInterface();
    }

    default public Stream<JMethodSig> streamMethods(Predicate<? super JMethodSymbol> prefilter) {
        return Stream.empty();
    }

    default public Stream<JMethodSig> streamDeclaredMethods(Predicate<? super JMethodSymbol> prefilter) {
        return Stream.empty();
    }

    default public List<JMethodSig> getConstructors() {
        return Collections.emptyList();
    }

    @Override
    public JTypeMirror subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> var1);

    public JTypeMirror withAnnotations(PSet<SymbolicValue.SymAnnot> var1);

    default public JTypeMirror addAnnotation(@NonNull SymbolicValue.SymAnnot newAnnot) {
        AssertionUtil.requireParamNotNull((String)"annot", (Object)newAnnot);
        return this.withAnnotations((PSet<SymbolicValue.SymAnnot>)this.getTypeAnnotations().plus((Object)newAnnot));
    }

    public boolean equals(Object var1);

    public String toString();
}

