/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.PolySite;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResolutionFailure {
    static final ResolutionFailure UNKNOWN = new ResolutionFailure(null, "log is disabled");
    private JMethodSig failedMethod;
    private PolySite<?> callSite;
    private MethodResolutionPhase phase;
    private final String reason;
    private final @Nullable JavaNode location;

    ResolutionFailure(@Nullable JavaNode location, String reason) {
        this.location = location;
        this.reason = reason;
    }

    void addContext(JMethodSig m, PolySite<?> callSite, MethodResolutionPhase phase) {
        this.failedMethod = m;
        this.callSite = callSite;
        this.phase = phase;
    }

    public @Nullable JavaNode getLocation() {
        return this.location != null ? this.location : (this.callSite != null ? this.callSite.getExpr().getLocation() : null);
    }

    public JMethodSig getFailedMethod() {
        return this.failedMethod;
    }

    public MethodResolutionPhase getPhase() {
        return this.phase;
    }

    public String getReason() {
        return this.reason;
    }

    public PolySite<?> getCallSite() {
        return this.callSite;
    }

    public String toString() {
        return "ResolutionFailure{failedMethod=" + this.failedMethod + ", callSite=" + this.callSite + ", phase=" + (Object)((Object)this.phase) + ", reason='" + this.reason + '\'' + ", location=" + this.location + '}';
    }
}

