/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.InternalInterfaces;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ASTList<N extends JavaNode>
extends AbstractJavaNode
implements Iterable<N> {
    protected final Class<N> elementType;

    ASTList(int id, Class<N> kind) {
        super(id);
        this.elementType = kind;
    }

    public int size() {
        return this.toStream().count();
    }

    public boolean isEmpty() {
        return this.toStream().isEmpty();
    }

    public List<N> toList() {
        return this.toStream().toList();
    }

    public NodeStream<N> toStream() {
        return this.children(this.elementType);
    }

    @Override
    public Iterator<N> iterator() {
        return this.toStream().iterator();
    }

    public N get(int i) {
        JavaNode n = (JavaNode)this.toStream().get(i);
        if (n == null) {
            throw new IndexOutOfBoundsException("Index " + i + " for length " + this.size());
        }
        return (N)n;
    }

    public static <N extends JavaNode> @NonNull List<N> orEmpty(@Nullable ASTList<N> list) {
        return list == null ? Collections.emptyList() : list.toList();
    }

    public static <N extends JavaNode> @NonNull NodeStream<N> orEmptyStream(@Nullable ASTList<N> list) {
        return list == null ? NodeStream.empty() : list.toStream();
    }

    public static int sizeOrZero(@Nullable ASTList<?> list) {
        return list == null ? 0 : list.size();
    }

    public static <N extends JavaNode> @Nullable N singleOrNull(@Nullable ASTList<N> list) {
        return list == null || list.size() != 1 ? null : (N)list.get(0);
    }

    static abstract class ASTMaybeEmptyListOf<T extends JavaNode>
    extends ASTList<T>
    implements InternalInterfaces.AllChildrenAreOfType<T> {
        ASTMaybeEmptyListOf(int id, Class<T> kind) {
            super(id, kind);
        }

        @Override
        public NodeStream<T> toStream() {
            return this.children();
        }
    }

    static abstract class ASTNonEmptyList<T extends JavaNode>
    extends ASTMaybeEmptyListOf<T>
    implements InternalInterfaces.AtLeastOneChildOfType<T> {
        ASTNonEmptyList(int id, Class<T> kind) {
            super(id, kind);
        }
    }
}

