/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimplifiableTestAssertionRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher OBJECT_EQUALS = InvocationMatcher.parse("_#equals(java.lang.Object)");

    public SimplifiableTestAssertionRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    public Object visit(ASTMethodCall node, Object data) {
        ASTArgumentList argList;
        boolean isAssertTrue = this.isAssertionCall(node, "assertTrue");
        boolean isAssertFalse = this.isAssertionCall(node, "assertFalse");
        if (isAssertTrue || isAssertFalse) {
            String suggestion;
            ASTArgumentList args = node.getArguments();
            ASTExpression lastArg = (ASTExpression)args.getLastChild();
            ASTInfixExpression eq = this.asEqualityExpr(lastArg);
            if (eq != null) {
                boolean isPositive;
                boolean bl = isPositive = this.isPositiveEqualityExpr(eq) == isAssertTrue;
                suggestion = JavaAstUtils.isNullLiteral(eq.getLeftOperand()) || JavaAstUtils.isNullLiteral(eq.getRightOperand()) ? (isPositive ? "assertNull" : "assertNonNull") : (this.isPrimitive(eq.getLeftOperand()) || this.isPrimitive(eq.getRightOperand()) ? (isPositive ? "assertEquals" : "assertNotEquals") : (isPositive ? "assertSame" : "assertNotSame"));
                this.asCtx(data).addViolation((Node)node, new Object[]{suggestion});
            } else {
                @Nullable ASTExpression negatedExprOperand = SimplifiableTestAssertionRule.getNegatedExprOperand(lastArg);
                if (OBJECT_EQUALS.matchesCall(negatedExprOperand)) {
                    suggestion = isAssertTrue ? "assertNotEquals" : "assertEquals";
                    this.asCtx(data).addViolation((Node)node, new Object[]{suggestion});
                } else if (negatedExprOperand != null) {
                    suggestion = isAssertTrue ? "assertFalse" : "assertTrue";
                    this.asCtx(data).addViolation((Node)node, new Object[]{suggestion});
                } else if (OBJECT_EQUALS.matchesCall(lastArg)) {
                    suggestion = isAssertTrue ? "assertEquals" : "assertNotEquals";
                    this.asCtx(data).addViolation((Node)node, new Object[]{suggestion});
                }
            }
        }
        boolean isAssertEquals = this.isAssertionCall(node, "assertEquals");
        boolean isAssertNotEquals = this.isAssertionCall(node, "assertNotEquals");
        if ((isAssertEquals || isAssertNotEquals) && (argList = node.getArguments()).size() >= 2) {
            ASTExpression comp0 = SimplifiableTestAssertionRule.getChildRev(argList, -1);
            ASTExpression comp1 = SimplifiableTestAssertionRule.getChildRev(argList, -2);
            if (JavaAstUtils.isBooleanLiteral(comp0) ^ JavaAstUtils.isBooleanLiteral(comp1)) {
                if (JavaAstUtils.isBooleanLiteral(comp1)) {
                    ASTExpression tmp = comp0;
                    comp0 = comp1;
                    comp1 = tmp;
                }
                if (comp1.getTypeMirror().isPrimitive(JPrimitiveType.PrimitiveTypeKind.BOOLEAN)) {
                    ASTBooleanLiteral literal = (ASTBooleanLiteral)comp0;
                    String suggestion = literal.isTrue() == isAssertEquals ? "assertTrue" : "assertFalse";
                    this.asCtx(data).addViolation((Node)node, new Object[]{suggestion});
                }
            }
        }
        return null;
    }

    private boolean isPrimitive(ASTExpression node) {
        return node.getTypeMirror().isPrimitive();
    }

    private static <T extends JavaNode> T getChildRev(@NonNull ASTList<T> list, int i) {
        assert (i < 0) : "Expecting negative offset";
        return list.get(list.getNumChildren() + i);
    }

    private boolean isAssertionCall(ASTMethodCall call, String methodName) {
        return call.getMethodName().equals(methodName) && !call.getOverloadSelectionInfo().isFailed() && TestFrameworksUtil.isCallOnAssertionContainer(call);
    }

    private ASTInfixExpression asEqualityExpr(ASTExpression node) {
        if (JavaAstUtils.isInfixExprWithOperator((JavaNode)node, BinaryOp.EQUALITY_OPS)) {
            return (ASTInfixExpression)node;
        }
        return null;
    }

    private boolean isPositiveEqualityExpr(ASTInfixExpression node) {
        return node != null && node.getOperator() == BinaryOp.EQ;
    }

    private static ASTExpression getNegatedExprOperand(ASTExpression node) {
        if (JavaAstUtils.isBooleanNegation(node)) {
            return ((ASTUnaryExpression)node).getOperand();
        }
        return null;
    }
}

