/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.ClassTypeImpl;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ClassMethodSigImpl
implements JMethodSig,
InternalMethodTypeItf {
    private final JMethodSig adaptedMethod;
    private final JClassType owner;
    private final JExecutableSymbol symbol;
    private @Nullable List<JTypeVar> tparams;
    private JTypeMirror resultType;
    private List<JTypeMirror> formals;
    private List<JTypeMirror> thrown;

    ClassMethodSigImpl(@NonNull JClassType owner, @NonNull JExecutableSymbol symbol) {
        this(owner, symbol, null, null, null, null, null);
    }

    private ClassMethodSigImpl(@NonNull JClassType owner, @NonNull JExecutableSymbol symbol, JMethodSig adapted, @Nullable List<JTypeVar> tparams, @Nullable JTypeMirror resultType, @Nullable List<JTypeMirror> formals, @Nullable List<JTypeMirror> thrown) {
        this.adaptedMethod = adapted == null ? this : adapted;
        this.owner = owner;
        this.symbol = symbol;
        this.resultType = resultType;
        this.formals = formals;
        this.thrown = thrown;
        this.tparams = tparams;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.owner.getTypeSystem();
    }

    @Override
    public JExecutableSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public JClassType getDeclaringType() {
        return this.owner;
    }

    @Override
    public JTypeMirror getAnnotatedReceiverType() {
        return this.symbol.getAnnotatedReceiverType(this.getTypeParamSubst());
    }

    @Override
    public JMethodSig getErasure() {
        return new ClassMethodSigImpl(this.owner.getErasure(), this.symbol, null, Collections.emptyList(), this.getReturnType().getErasure(), TypeOps.erase(this.getFormalParameters()), TypeOps.erase(this.getThrownExceptions()));
    }

    @Override
    public JTypeMirror getReturnType() {
        if (this.resultType == null) {
            this.resultType = this.symbol instanceof JMethodSymbol ? (this.owner.isRaw() ? ClassTypeImpl.eraseToRaw(((JMethodSymbol)this.symbol).getReturnType(Substitution.EMPTY), this.getTypeParamSubst()) : ((JMethodSymbol)this.symbol).getReturnType(this.getTypeParamSubst())) : this.owner;
        }
        return this.resultType;
    }

    @Override
    public List<JTypeMirror> getFormalParameters() {
        if (this.formals == null) {
            this.formals = this.owner.isRaw() ? CollectionUtil.map(this.symbol.getFormalParameterTypes(Substitution.EMPTY), m -> ClassTypeImpl.eraseToRaw(m, this.getTypeParamSubst())) : this.symbol.getFormalParameterTypes(this.getTypeParamSubst());
        }
        return this.formals;
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        if (this.tparams == null) {
            this.tparams = TypeOps.substInBoundsOnly(this.symbol.getTypeParameters(), this.owner.getTypeParamSubst());
        }
        return this.tparams;
    }

    @Override
    public List<JTypeMirror> getThrownExceptions() {
        if (this.thrown == null) {
            this.thrown = this.owner.isRaw() ? CollectionUtil.map(this.symbol.getThrownExceptionTypes(Substitution.EMPTY), m -> ClassTypeImpl.eraseToRaw(m, this.getTypeParamSubst())) : this.symbol.getThrownExceptionTypes(this.getTypeParamSubst());
        }
        return this.thrown;
    }

    @Override
    public JMethodSig withReturnType(JTypeMirror returnType) {
        return new ClassMethodSigImpl(this.owner, this.symbol, this.adaptedMethod, this.tparams, returnType, this.formals, this.thrown);
    }

    @Override
    public JMethodSig withTypeParams(@Nullable List<JTypeVar> tparams) {
        return new ClassMethodSigImpl(this.owner, this.symbol, this.adaptedMethod, tparams, this.resultType, this.formals, this.thrown);
    }

    @Override
    public JMethodSig subst(Function<? super SubstVar, ? extends JTypeMirror> fun) {
        if (Substitution.isEmptySubst(fun)) {
            return this;
        }
        return new ClassMethodSigImpl(this.owner, this.symbol, this.adaptedMethod, this.tparams, TypeOps.subst(this.getReturnType(), fun), TypeOps.subst(this.getFormalParameters(), fun), TypeOps.subst(this.getThrownExceptions(), fun));
    }

    @Override
    public JMethodSig markAsAdapted() {
        return new ClassMethodSigImpl(this.owner, this.symbol, null, this.tparams, this.resultType, this.formals, this.thrown);
    }

    @Override
    public JMethodSig withOwner(JTypeMirror newOwner) {
        if (newOwner instanceof JClassType && Objects.equals(newOwner.getSymbol(), this.owner.getSymbol())) {
            return new ClassMethodSigImpl((JClassType)newOwner, this.symbol, this.adaptedMethod, this.tparams, this.resultType, this.formals, this.thrown);
        }
        throw new IllegalArgumentException(newOwner + " cannot be the owner of " + this);
    }

    @Override
    public JMethodSig originalMethod() {
        return new ClassMethodSigImpl(this.owner, this.symbol);
    }

    @Override
    public JMethodSig adaptedMethod() {
        return this.adaptedMethod == null ? this.originalMethod() : this.adaptedMethod;
    }

    private Substitution getTypeParamSubst() {
        return this.owner.getTypeParamSubst();
    }

    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JMethodSig)) {
            return false;
        }
        JMethodSig that = (JMethodSig)o;
        return TypeOps.isSameType(this, that);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getFormalParameters(), this.getReturnType());
    }
}

