/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Classpath;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Loader;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureParser;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsmSymbolResolver
implements SymbolResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AsmSymbolResolver.class);
    static final int ASM_API_V = 589824;
    private final TypeSystem ts;
    private final Classpath classLoader;
    private final SignatureParser typeLoader;
    private final ConcurrentMap<String, ClassStub> knownStubs = new ConcurrentHashMap<String, ClassStub>();
    private final ClassStub failed;

    public AsmSymbolResolver(TypeSystem ts, Classpath classLoader) {
        this.ts = ts;
        this.classLoader = classLoader;
        this.typeLoader = new SignatureParser(this);
        this.failed = new ClassStub(this, "/*failed-lookup*/", Loader.FailedLoader.INSTANCE, 0);
    }

    @Override
    public @Nullable JClassSymbol resolveClassFromBinaryName(@NonNull String binaryName) {
        AssertionUtil.requireParamNotNull((String)"binaryName", (Object)binaryName);
        String internalName = AsmSymbolResolver.getInternalName(binaryName);
        ClassStub found = this.knownStubs.computeIfAbsent(internalName, iname -> {
            @Nullable InputStream inputStream = this.getStreamOfInternalName((String)iname);
            if (inputStream == null) {
                return this.failed;
            }
            return new ClassStub(this, (String)iname, new Loader.StreamLoader(binaryName, inputStream), 0);
        });
        if (!found.hasCanonicalName()) {
            this.knownStubs.put(internalName, this.failed);
            found = this.failed;
        }
        return found == this.failed ? null : found;
    }

    SignatureParser getSigParser() {
        return this.typeLoader;
    }

    TypeSystem getTypeSystem() {
        return this.ts;
    }

    static @NonNull String getInternalName(@NonNull String binaryName) {
        return binaryName.replace('.', '/');
    }

    @Nullable InputStream getStreamOfInternalName(String internalName) {
        return this.classLoader.findResource(internalName + ".class");
    }

    @Nullable ClassStub resolveFromInternalNameCannotFail(@Nullable String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.resolveFromInternalNameCannotFail(internalName, 0);
    }

    @NonNull ClassStub resolveFromInternalNameCannotFail(@NonNull String internalName, int observedArity) {
        return this.knownStubs.compute(internalName, (iname, prev) -> {
            if (prev != this.failed && prev != null) {
                return prev;
            }
            @Nullable InputStream inputStream = this.getStreamOfInternalName((String)iname);
            Loader loader = inputStream == null ? Loader.FailedLoader.INSTANCE : new Loader.StreamLoader(internalName, inputStream);
            return new ClassStub(this, (String)iname, loader, observedArity);
        });
    }

    @Override
    public void logStats() {
        int numParsed = 0;
        int numFailed = 0;
        int numFailedQueries = 0;
        int numNotParsed = 0;
        for (ClassStub stub : this.knownStubs.values()) {
            if (stub == this.failed) {
                ++numFailedQueries;
                continue;
            }
            if (stub.isNotParsed()) {
                ++numNotParsed;
                continue;
            }
            if (!stub.isFailed()) {
                ++numParsed;
                continue;
            }
            ++numFailed;
        }
        LOG.trace("Of {} distinct queries to the classloader, {} queries failed, {} classes were found and parsed successfully, {} were found but failed parsing (!), {} were found but never parsed.", new Object[]{this.knownStubs.size(), numFailedQueries, numParsed, numFailed, numNotParsed});
    }
}

