/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PreserveStackTraceRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher INIT_CAUSE = InvocationMatcher.parse("java.lang.Throwable#initCause(_)");
    private static final InvocationMatcher.CompoundInvocationMatcher ALLOWED_GETTERS = InvocationMatcher.parseAll("java.lang.Throwable#fillInStackTrace()", "java.lang.reflect.InvocationTargetException#getTargetException()", "java.lang.reflect.InvocationTargetException#getCause()", "java.security.PrivilegedActionException#getException()", "java.security.PrivilegedActionException#getCause()");
    private final Set<ASTVariableId> recursingOnVars = new HashSet<ASTVariableId>();

    public PreserveStackTraceRule() {
        super(ASTCatchClause.class, new Class[0]);
    }

    public Object visit(ASTCatchClause catchStmt, Object data) {
        ASTVariableId exceptionParam = catchStmt.getParameter().getVarId();
        if (JavaRuleUtil.isExplicitUnusedVarName(exceptionParam.getName())) {
            return null;
        }
        for (ASTThrowStatement throwStatement : catchStmt.getBody().descendants(ASTThrowStatement.class)) {
            ASTExpression thrownExpr = throwStatement.getExpr();
            if (this.exprConsumesException(exceptionParam, thrownExpr, true)) continue;
            this.asCtx(data).addViolation((Node)thrownExpr, new Object[]{exceptionParam.getName()});
        }
        this.recursingOnVars.clear();
        return null;
    }

    private boolean exprConsumesException(ASTVariableId exceptionParam, ASTExpression expr, boolean mayBeSelf) {
        if (expr instanceof ASTConstructorCall) {
            return this.ctorConsumesException(exceptionParam, (ASTConstructorCall)expr);
        }
        if (expr instanceof ASTMethodCall) {
            return this.methodConsumesException(exceptionParam, (ASTMethodCall)expr);
        }
        if (expr instanceof ASTCastExpression) {
            ASTExpression innermost = JavaAstUtils.peelCasts(expr);
            return this.exprConsumesException(exceptionParam, innermost, mayBeSelf);
        }
        if (expr instanceof ASTConditionalExpression) {
            ASTConditionalExpression ternary = (ASTConditionalExpression)expr;
            return this.exprConsumesException(exceptionParam, ternary.getThenBranch(), mayBeSelf) && this.exprConsumesException(exceptionParam, ternary.getElseBranch(), mayBeSelf);
        }
        if (expr instanceof ASTVariableAccess) {
            JVariableSymbol referencedSym = ((ASTVariableAccess)expr).getReferencedSym();
            if (referencedSym == null) {
                return true;
            }
            ASTVariableId decl = (ASTVariableId)referencedSym.tryGetNode();
            if (decl == exceptionParam) {
                return mayBeSelf;
            }
            if (decl == null || decl.isFormalParameter() || decl.isField()) {
                return false;
            }
            if (!this.recursingOnVars.add(decl)) {
                return false;
            }
            if (this.exprConsumesException(exceptionParam, decl.getInitializer(), mayBeSelf)) {
                return true;
            }
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : decl.getLocalUsages()) {
                if (this.assignmentRhsConsumesException(exceptionParam, decl, usage)) {
                    return true;
                }
                if (!JavaAstUtils.followingCallChain(usage).any(it -> this.consumesExceptionNonRecursive(exceptionParam, (ASTExpression)it))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean assignmentRhsConsumesException(ASTVariableId exceptionParam, ASTVariableId lhsVariable, ASTAssignableExpr.ASTNamedReferenceExpr usage) {
        if (usage.getIndexInParent() == 0) {
            ASTExpression assignmentRhs = JavaAstUtils.getOtherOperandIfInAssignmentExpr(usage);
            boolean rhsIsSelfReferential = NodeStream.of((Node)assignmentRhs).descendantsOrSelf().filterIs(ASTVariableAccess.class).any(it -> JavaAstUtils.isReferenceToVar((ASTExpression)it, (JVariableSymbol)lhsVariable.getSymbol()));
            return !rhsIsSelfReferential && this.exprConsumesException(exceptionParam, assignmentRhs, true);
        }
        return false;
    }

    private boolean ctorConsumesException(ASTVariableId exceptionParam, ASTConstructorCall ctorCall) {
        return ctorCall.isAnonymousClass() && this.callsInitCauseInAnonInitializer(exceptionParam, ctorCall) || this.anArgumentConsumesException(exceptionParam, ctorCall);
    }

    private boolean consumesExceptionNonRecursive(ASTVariableId exceptionParam, ASTExpression expr) {
        if (expr instanceof ASTConstructorCall) {
            return this.ctorConsumesException(exceptionParam, (ASTConstructorCall)expr);
        }
        return expr instanceof InvocationNode && this.anArgumentConsumesException(exceptionParam, (InvocationNode)((Object)expr));
    }

    private boolean methodConsumesException(ASTVariableId exceptionParam, ASTMethodCall call) {
        if (this.anArgumentConsumesException(exceptionParam, call)) {
            return true;
        }
        ASTExpression qualifier = call.getQualifier();
        if (qualifier == null) {
            return false;
        }
        boolean mayBeSelf = ALLOWED_GETTERS.anyMatch(call);
        return this.exprConsumesException(exceptionParam, qualifier, mayBeSelf);
    }

    private boolean callsInitCauseInAnonInitializer(ASTVariableId exceptionParam, ASTConstructorCall ctorCall) {
        return NodeStream.of((Node)ctorCall.getAnonymousClassDeclaration()).flatMap(ASTTypeDeclaration::getDeclarations).map(NodeStream.asInstanceOf(ASTFieldDeclaration.class, (Class[])new Class[]{ASTInitializer.class})).descendants().filterIs(ASTMethodCall.class).any(it -> this.isInitCauseWithTargetInArg(exceptionParam, (JavaNode)it));
    }

    private boolean isInitCauseWithTargetInArg(ASTVariableId exceptionSym, JavaNode expr) {
        return INIT_CAUSE.matchesCall(expr) && this.anArgumentConsumesException(exceptionSym, (ASTMethodCall)expr);
    }

    private boolean anArgumentConsumesException(@NonNull ASTVariableId exceptionParam, InvocationNode thrownExpr) {
        for (ASTExpression arg : ASTList.orEmptyStream(thrownExpr.getArguments())) {
            if (!this.exprConsumesException(exceptionParam, arg, true)) continue;
            return true;
        }
        return false;
    }
}

