/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpressionList;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ForLoopCanBeForeachRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher ITERATOR_CALL = InvocationMatcher.parse("java.lang.Iterable#iterator()");
    private static final InvocationMatcher ITERATOR_NEXT = InvocationMatcher.parse("java.util.Iterator#next()");
    private static final InvocationMatcher ITERATOR_HAS_NEXT = InvocationMatcher.parse("java.util.Iterator#hasNext()");
    private static final InvocationMatcher COLLECTION_SIZE = InvocationMatcher.parse("java.util.Collection#size()");
    private static final InvocationMatcher LIST_GET = InvocationMatcher.parse("java.util.List#get(int)");

    public ForLoopCanBeForeachRule() {
        super(ASTForStatement.class, new Class[0]);
    }

    public Object visit(ASTForStatement forLoop, Object data) {
        @Nullable ASTStatement init = forLoop.getInit();
        @Nullable ASTStatementExpressionList update = forLoop.getUpdate();
        ASTExpression guardCondition = forLoop.getCondition();
        if (init == null && update == null || guardCondition == null) {
            return data;
        }
        ASTVariableId index = this.getIndexVarDeclaration(init, update);
        if (index == null) {
            return data;
        }
        if (index.getTypeMirror().isPrimitive(JPrimitiveType.PrimitiveTypeKind.INT)) {
            ASTAssignableExpr.ASTNamedReferenceExpr iterable = this.findIterableFromCondition(guardCondition, index);
            if (iterable != null && (this.isReplaceableArrayLoop(forLoop, index, iterable) || this.isReplaceableListLoop(forLoop, index, iterable))) {
                this.asCtx(data).addViolation((Node)forLoop);
            }
        } else if (TypeTestUtil.isA(Iterator.class, index.getTypeMirror())) {
            if (ForLoopCanBeForeachRule.isReplaceableIteratorLoop(index, forLoop)) {
                this.asCtx(data).addViolation((Node)forLoop);
            }
            return data;
        }
        return data;
    }

    private @Nullable ASTVariableId getIndexVarDeclaration(@Nullable ASTStatement init, ASTStatementExpressionList update) {
        ASTVariableId first;
        NodeStream varIds;
        if (init == null) {
            return this.guessIndexVarFromUpdate(update);
        }
        if (init instanceof ASTLocalVariableDeclaration && (varIds = ((ASTLocalVariableDeclaration)init).getVarIds()).count() == 1 && (ITERATOR_CALL.matchesCall((first = (ASTVariableId)varIds.firstOrThrow()).getInitializer()) || JavaAstUtils.isLiteralInt(first.getInitializer(), 0))) {
            return first;
        }
        return null;
    }

    private @Nullable ASTVariableId guessIndexVarFromUpdate(ASTStatementExpressionList update) {
        return (ASTVariableId)NodeStream.of((Node)update).filter(it -> it.getNumChildren() == 1).firstChild(ASTUnaryExpression.class).map(this::asIPlusPlus).first();
    }

    private @Nullable ASTVariableId asIPlusPlus(ASTExpression update) {
        return NodeStream.of((Node)update).filterIs(ASTUnaryExpression.class).filter(it -> it.getOperator().isIncrement()).map(ASTUnaryExpression::getOperand).filterIs(ASTVariableAccess.class).firstOpt().map(ASTAssignableExpr.ASTNamedReferenceExpr::getReferencedSym).map(rec$ -> (ASTVariableId)((JVariableSymbol)rec$).tryGetNode()).orElse(null);
    }

    private @Nullable ASTAssignableExpr.ASTNamedReferenceExpr findIterableFromCondition(ASTExpression guardCondition, ASTVariableId indexVar) {
        if (!JavaAstUtils.isInfixExprWithOperator((JavaNode)guardCondition, BinaryOp.COMPARISON_OPS)) {
            return null;
        }
        ASTInfixExpression condition = (ASTInfixExpression)guardCondition;
        BinaryOp op = condition.getOperator();
        if (!JavaAstUtils.isReferenceToVar(condition.getLeftOperand(), (JVariableSymbol)indexVar.getSymbol())) {
            return null;
        }
        NodeStream rhs = NodeStream.empty();
        if (op == BinaryOp.LT) {
            rhs = NodeStream.of((Node)condition.getRightOperand());
        } else if (op == BinaryOp.LE) {
            rhs = NodeStream.of((Node)condition.getRightOperand()).filterIs(ASTInfixExpression.class).filter(it -> it.getOperator() == BinaryOp.SUB).filter(it -> JavaAstUtils.isLiteralInt(it.getRightOperand(), 1)).map(rec$ -> ((ASTInfixExpression)rec$).getLeftOperand());
        }
        if (rhs.isEmpty()) {
            return null;
        }
        ASTExpression sizeExpr = (ASTExpression)rhs.get(0);
        ASTExpression iterableExpr = null;
        if (sizeExpr instanceof ASTFieldAccess && "length".equals(((ASTFieldAccess)sizeExpr).getName())) {
            iterableExpr = ((ASTFieldAccess)sizeExpr).getQualifier();
        } else if (COLLECTION_SIZE.matchesCall(sizeExpr)) {
            iterableExpr = ((ASTMethodCall)sizeExpr).getQualifier();
        }
        if (!(iterableExpr instanceof ASTAssignableExpr.ASTNamedReferenceExpr) || ((ASTAssignableExpr.ASTNamedReferenceExpr)iterableExpr).getReferencedSym() == null) {
            return null;
        }
        return (ASTAssignableExpr.ASTNamedReferenceExpr)iterableExpr;
    }

    private boolean isReplaceableArrayLoop(ASTForStatement loop, ASTVariableId index, ASTAssignableExpr.ASTNamedReferenceExpr arrayDeclaration) {
        return arrayDeclaration.getTypeMirror().isArray() && this.occurrencesMatch(loop, index, arrayDeclaration, (i, iterable, expr) -> this.isArrayAccessIndex(expr, iterable));
    }

    private boolean isReplaceableListLoop(ASTForStatement loop, ASTVariableId index, ASTAssignableExpr.ASTNamedReferenceExpr listDeclaration) {
        return TypeTestUtil.isA(List.class, listDeclaration.getTypeMirror()) && this.occurrencesMatch(loop, index, listDeclaration, (i, iterable, expr) -> this.isListGetIndex(expr, iterable));
    }

    private boolean isArrayAccessIndex(ASTAssignableExpr.ASTNamedReferenceExpr usage, ASTAssignableExpr.ASTNamedReferenceExpr arrayVar) {
        if (!(usage.getParent() instanceof ASTArrayAccess)) {
            return false;
        }
        ASTArrayAccess arrayAccess = (ASTArrayAccess)usage.getParent();
        return arrayAccess.getAccessType() == ASTAssignableExpr.AccessType.READ && JavaAstUtils.isReferenceToSameVar(arrayAccess.getQualifier(), arrayVar);
    }

    private boolean isListGetIndex(ASTAssignableExpr.ASTNamedReferenceExpr usage, ASTAssignableExpr.ASTNamedReferenceExpr listVar) {
        return usage.getParent() instanceof ASTArgumentList && LIST_GET.matchesCall((JavaNode)((JavaNode)usage.getParent()).getParent()) && JavaAstUtils.isReferenceToSameVar(((ASTMethodCall)((JavaNode)usage.getParent()).getParent()).getQualifier(), listVar);
    }

    private boolean occurrencesMatch(ASTForStatement loop, ASTVariableId index, ASTAssignableExpr.ASTNamedReferenceExpr collection, OccurrenceMatcher getMatcher) {
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : index.getLocalUsages()) {
            ASTExpression toplevel = JavaAstUtils.getTopLevelExpr(usage);
            boolean isInUpdateOrCond = loop.getUpdate() == toplevel.getParent() || loop.getCondition() == toplevel;
            if (isInUpdateOrCond || getMatcher.matches(index, collection, usage)) continue;
            return false;
        }
        return true;
    }

    private static boolean isReplaceableIteratorLoop(ASTVariableId var, ASTForStatement stmt) {
        List<ASTAssignableExpr.ASTNamedReferenceExpr> usages = var.getLocalUsages();
        if (usages.size() != 2) {
            return false;
        }
        ASTAssignableExpr.ASTNamedReferenceExpr u1 = usages.get(0);
        ASTAssignableExpr.ASTNamedReferenceExpr u2 = usages.get(1);
        return ForLoopCanBeForeachRule.isHasNextInCondition(u1, stmt) && ForLoopCanBeForeachRule.isNextInLoop(u2, stmt) || ForLoopCanBeForeachRule.isNextInLoop(u1, stmt) && ForLoopCanBeForeachRule.isHasNextInCondition(u2, stmt);
    }

    private static boolean isNextInLoop(ASTAssignableExpr.ASTNamedReferenceExpr u1, ASTForStatement stmt) {
        return ITERATOR_NEXT.matchesCall((JavaNode)u1.getParent()) && u1.ancestors().any(it -> it == stmt);
    }

    private static boolean isHasNextInCondition(ASTAssignableExpr.ASTNamedReferenceExpr u1, ASTForStatement forStmt) {
        return forStmt.getCondition() == u1.getParent() && ITERATOR_HAS_NEXT.matchesCall((JavaNode)u1.getParent());
    }

    private static interface OccurrenceMatcher {
        public boolean matches(ASTVariableId var1, ASTAssignableExpr.ASTNamedReferenceExpr var2, ASTAssignableExpr.ASTNamedReferenceExpr var3);
    }
}

