/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.cpd;

import java.util.Deque;
import java.util.LinkedList;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.cpd.impl.JavaCCTokenFilter;
import net.sourceforge.pmd.cpd.impl.JavaccCpdLexer;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaTokenKinds;
import net.sourceforge.pmd.lang.java.ast.SyntacticJavaTokenizerFactory;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProperties;

public class JavaCpdLexer
extends JavaccCpdLexer {
    private static final String CPD_START = "\"CPD-START\"";
    private static final String CPD_END = "\"CPD-END\"";
    private final boolean ignoreAnnotations;
    private final boolean ignoreLiterals;
    private final boolean ignoreIdentifiers;
    private final ConstructorDetector constructorDetector;

    public JavaCpdLexer(JavaLanguageProperties properties) {
        this.ignoreAnnotations = (Boolean)properties.getProperty(CpdLanguageProperties.CPD_IGNORE_METADATA);
        this.ignoreLiterals = (Boolean)properties.getProperty(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
        this.ignoreIdentifiers = (Boolean)properties.getProperty(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        this.constructorDetector = new ConstructorDetector(this.ignoreIdentifiers);
    }

    protected TokenManager<JavaccToken> makeLexerImpl(TextDocument doc) {
        return SyntacticJavaTokenizerFactory.createTokenizer(CharStream.create((TextDocument)doc, (JavaccTokenDocument.TokenDocumentBehavior)InternalApiBridge.javaTokenDoc()));
    }

    protected TokenManager<JavaccToken> filterTokenStream(TokenManager<JavaccToken> tokenManager) {
        return new JavaTokenFilter(tokenManager, this.ignoreAnnotations);
    }

    protected void processToken(TokenFactory tokenEntries, JavaccToken javaToken) {
        String image = javaToken.getImage();
        this.constructorDetector.restoreConstructorToken(tokenEntries, javaToken);
        if (this.ignoreLiterals && (javaToken.kind == 75 || javaToken.kind == 74 || javaToken.kind == 61 || javaToken.kind == 66)) {
            image = JavaTokenKinds.describe(javaToken.kind);
        }
        if (this.ignoreIdentifiers && javaToken.kind == 82) {
            image = JavaTokenKinds.describe(javaToken.kind);
        }
        this.constructorDetector.processToken(javaToken);
        tokenEntries.recordToken(image, javaToken.getReportLocation());
    }

    private static class TypeDeclaration {
        int indentationLevel;
        String name;

        TypeDeclaration(int indentationLevel) {
            this.indentationLevel = indentationLevel;
        }
    }

    private static class ConstructorDetector {
        private final boolean ignoreIdentifiers;
        private final Deque<TypeDeclaration> classMembersIndentations;
        private int currentNestingLevel;
        private boolean storeNextIdentifier;
        private String prevIdentifier;

        ConstructorDetector(boolean ignoreIdentifiers) {
            this.ignoreIdentifiers = ignoreIdentifiers;
            this.currentNestingLevel = 0;
            this.classMembersIndentations = new LinkedList<TypeDeclaration>();
        }

        public void processToken(JavaccToken currentToken) {
            if (!this.ignoreIdentifiers) {
                return;
            }
            switch (currentToken.kind) {
                case 82: {
                    if ("enum".equals(currentToken.getImage())) {
                        this.pushTypeDeclaration();
                    } else if (this.storeNextIdentifier) {
                        this.classMembersIndentations.peek().name = currentToken.getImage();
                        this.storeNextIdentifier = false;
                    }
                    this.prevIdentifier = currentToken.getImage();
                    break;
                }
                case 17: {
                    this.pushTypeDeclaration();
                    break;
                }
                case 87: {
                    ++this.currentNestingLevel;
                    break;
                }
                case 88: {
                    if (!this.classMembersIndentations.isEmpty() && this.classMembersIndentations.peek().indentationLevel == this.currentNestingLevel) {
                        this.classMembersIndentations.pop();
                    }
                    --this.currentNestingLevel;
                    break;
                }
                default: {
                    if (!this.storeNextIdentifier) break;
                    this.classMembersIndentations.pop();
                    this.storeNextIdentifier = false;
                }
            }
        }

        private void pushTypeDeclaration() {
            TypeDeclaration cd = new TypeDeclaration(this.currentNestingLevel + 1);
            this.classMembersIndentations.push(cd);
            this.storeNextIdentifier = true;
        }

        public void restoreConstructorToken(TokenFactory tokenEntries, JavaccToken currentToken) {
            if (!this.ignoreIdentifiers) {
                return;
            }
            if (currentToken.kind == 85 && !this.classMembersIndentations.isEmpty() && this.classMembersIndentations.peek().name.equals(this.prevIdentifier)) {
                TokenEntry lastToken = tokenEntries.peekLastToken();
                tokenEntries.setImage(lastToken, this.prevIdentifier);
            }
        }
    }

    private static class JavaTokenFilter
    extends JavaCCTokenFilter {
        private boolean isAnnotation = false;
        private boolean nextTokenEndsAnnotation = false;
        private int annotationStack = 0;
        private boolean discardingSemicolon = false;
        private boolean discardingKeywords = false;
        private boolean discardingSuppressing = false;
        private boolean discardingAnnotations = false;
        private boolean ignoreAnnotations = false;

        JavaTokenFilter(TokenManager<JavaccToken> tokenManager, boolean ignoreAnnotations) {
            super(tokenManager);
            this.ignoreAnnotations = ignoreAnnotations;
        }

        protected void analyzeToken(JavaccToken token) {
            this.detectAnnotations(token);
            this.skipSemicolon(token);
            this.skipPackageAndImport(token);
            this.skipAnnotationSuppression(token);
            if (this.ignoreAnnotations) {
                this.skipAnnotations();
            }
        }

        private void skipPackageAndImport(JavaccToken currentToken) {
            if (currentToken.kind == 41 || currentToken.kind == 33) {
                this.discardingKeywords = true;
            } else if (this.discardingKeywords && currentToken.kind == 91) {
                this.discardingKeywords = false;
            }
        }

        private void skipSemicolon(JavaccToken currentToken) {
            if (currentToken.kind == 91) {
                this.discardingSemicolon = true;
            } else if (this.discardingSemicolon) {
                this.discardingSemicolon = false;
            }
        }

        private void skipAnnotationSuppression(JavaccToken currentToken) {
            if (this.isAnnotation) {
                if (!this.discardingSuppressing && currentToken.kind == 75 && JavaCpdLexer.CPD_START.equals(currentToken.getImage())) {
                    this.discardingSuppressing = true;
                } else if (this.discardingSuppressing && currentToken.kind == 75 && JavaCpdLexer.CPD_END.equals(currentToken.getImage())) {
                    this.discardingSuppressing = false;
                }
            }
        }

        private void skipAnnotations() {
            if (!this.discardingAnnotations && this.isAnnotation) {
                this.discardingAnnotations = true;
            } else if (this.discardingAnnotations && !this.isAnnotation) {
                this.discardingAnnotations = false;
            }
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingSemicolon || this.discardingKeywords || this.discardingAnnotations || this.discardingSuppressing;
        }

        private void detectAnnotations(JavaccToken currentToken) {
            if (this.isAnnotation && this.nextTokenEndsAnnotation) {
                this.isAnnotation = false;
                this.nextTokenEndsAnnotation = false;
            }
            if (this.isAnnotation) {
                if (currentToken.kind == 85) {
                    ++this.annotationStack;
                } else if (currentToken.kind == 86) {
                    --this.annotationStack;
                    if (this.annotationStack == 0) {
                        this.nextTokenEndsAnnotation = true;
                    }
                } else if (this.annotationStack == 0 && currentToken.kind != 82 && currentToken.kind != 85) {
                    this.isAnnotation = false;
                }
            }
            if (currentToken.kind == 94) {
                this.isAnnotation = true;
            }
        }
    }
}

