/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprCheckHelper;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.PhaseOverloadSet;
import net.sourceforge.pmd.lang.java.types.internal.infer.PolySite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailedException;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailure;
import net.sourceforge.pmd.lang.java.types.internal.infer.SupertypeCheckCache;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Infer {
    final ExprOps exprOps;
    public final TypeInferenceLogger LOG;
    private final boolean isPreJava8;
    private final TypeSystem ts;
    final ExprMirror.InvocationMirror.MethodCtDecl NO_CTDECL;
    final ExprMirror.InvocationMirror.MethodCtDecl FAILED_INVOCATION;
    private final SupertypeCheckCache supertypeCheckCache = new SupertypeCheckCache();

    public Infer(TypeSystem ts, int jdkVersion, TypeInferenceLogger logger) {
        this.ts = ts;
        this.isPreJava8 = jdkVersion < 8;
        this.LOG = logger;
        this.NO_CTDECL = ExprMirror.InvocationMirror.MethodCtDecl.unresolved(ts);
        this.FAILED_INVOCATION = ExprMirror.InvocationMirror.MethodCtDecl.unresolved(ts);
        this.exprOps = new ExprOps(this);
    }

    public boolean isPreJava8() {
        return this.isPreJava8;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public TypeInferenceLogger getLogger() {
        return this.LOG;
    }

    public PolySite<ExprMirror.FunctionalExprMirror> newFunctionalSite(ExprMirror.FunctionalExprMirror mirror, @Nullable JTypeMirror expectedType) {
        return new PolySite<ExprMirror.FunctionalExprMirror>(mirror, expectedType);
    }

    public MethodCallSite newCallSite(ExprMirror.InvocationMirror expr, @Nullable JTypeMirror expectedType) {
        return this.newCallSite(expr, expectedType, null, null, false);
    }

    MethodCallSite newCallSite(ExprMirror.InvocationMirror expr, @Nullable JTypeMirror expectedType, @Nullable MethodCallSite outerSite, @Nullable InferenceContext outerCtx, boolean isSpecificityCheck) {
        return new MethodCallSite(expr, expectedType, outerSite, outerCtx != null ? outerCtx : this.emptyContext(), isSpecificityCheck);
    }

    InferenceContext emptyContext() {
        return this.newContextFor(Collections.emptyList());
    }

    @NonNull InferenceContext newContextFor(JMethodSig m) {
        return this.newContextFor(m.getTypeParameters());
    }

    InferenceContext newContextFor(List<JTypeVar> tvars) {
        return new InferenceContext(this.ts, this.supertypeCheckCache, tvars, this.LOG);
    }

    public void inferFunctionalExprInUnambiguousContext(PolySite<ExprMirror.FunctionalExprMirror> site) {
        ExprMirror.FunctionalExprMirror expr = site.getExpr();
        JTypeMirror expected = site.getExpectedType();
        try {
            if (expected == null) {
                throw ResolutionFailedException.missingTargetTypeForFunctionalExpr(this.LOG, expr);
            }
            this.addBoundOrDefer(null, this.emptyContext(), MethodResolutionPhase.INVOC_LOOSE, expr, expected);
        }
        catch (ResolutionFailedException rfe) {
            rfe.getFailure().addContext(null, site, null);
            this.LOG.logResolutionFail(rfe.getFailure());
            expr.setInferredType(expected == null ? this.ts.UNKNOWN : expected);
            if (expr instanceof ExprMirror.MethodRefMirror) {
                ExprMirror.MethodRefMirror mref = (ExprMirror.MethodRefMirror)expr;
                mref.setFunctionalMethod(this.ts.UNRESOLVED_METHOD);
                mref.setCompileTimeDecl(this.ts.UNRESOLVED_METHOD);
            }
            ExprMirror.LambdaExprMirror lambda = (ExprMirror.LambdaExprMirror)expr;
            lambda.setFunctionalMethod(this.ts.UNRESOLVED_METHOD);
        }
    }

    public void inferInvocationRecursively(MethodCallSite site) {
        ExprMirror.InvocationMirror.MethodCtDecl ctdecl = this.goToInvocationWithFallback(site);
        ExprMirror.InvocationMirror expr = (ExprMirror.InvocationMirror)site.getExpr();
        expr.setCtDecl(ctdecl);
        if (ctdecl == this.NO_CTDECL) {
            expr.setInferredType(this.fallbackType(expr));
        } else {
            expr.setInferredType(ctdecl.getMethodType().getReturnType());
        }
    }

    private ExprMirror.InvocationMirror.MethodCtDecl goToInvocationWithFallback(MethodCallSite site) {
        ExprMirror.InvocationMirror.MethodCtDecl ctdecl = this.getCompileTimeDecl(site);
        if (ctdecl == this.NO_CTDECL) {
            return this.NO_CTDECL;
        }
        site.clearFailures();
        ExprMirror.InvocationMirror.MethodCtDecl invocType = this.finishInstantiation(site, ctdecl);
        if (invocType != this.FAILED_INVOCATION) {
            return invocType;
        }
        JMethodSig fallback = this.deleteTypeParams(ctdecl.getMethodType().internalApi().adaptedMethod());
        this.LOG.fallbackInvocation(fallback, site);
        return ctdecl.withMethod(fallback, true);
    }

    private JTypeMirror fallbackType(ExprMirror.PolyExprMirror expr) {
        JTypeMirror t = expr.unresolvedType();
        return t == null ? this.ts.UNKNOWN : t;
    }

    private JMethodSig deleteTypeParams(JMethodSig m) {
        if (!m.isGeneric()) {
            return m;
        }
        List<JTypeVar> tparams = m.getTypeParameters();
        List<JTypeMirror> nErrors = Collections.nCopies(tparams.size(), this.ts.ERROR);
        return m.subst((Function)Substitution.mapping(tparams, nErrors));
    }

    @NonNull ExprMirror.InvocationMirror.MethodCtDecl determineInvocationTypeOrFail(MethodCallSite site) {
        ExprMirror.InvocationMirror.MethodCtDecl ctdecl = this.getCompileTimeDecl(site);
        if (ctdecl == this.NO_CTDECL) {
            return ctdecl;
        }
        return this.finishInstantiation(site, ctdecl);
    }

    public @NonNull ExprMirror.InvocationMirror.MethodCtDecl getCompileTimeDecl(MethodCallSite site) {
        if (((ExprMirror.InvocationMirror)site.getExpr()).getCtDecl() == null) {
            ExprMirror.InvocationMirror.MethodCtDecl ctdecl = this.computeCompileTimeDecl(site);
            ((ExprMirror.InvocationMirror)site.getExpr()).setCtDecl(ctdecl);
        }
        return ((ExprMirror.InvocationMirror)site.getExpr()).getCtDecl();
    }

    private @NonNull ExprMirror.InvocationMirror.MethodCtDecl computeCompileTimeDecl(MethodCallSite site) {
        ArrayList<JMethodSig> potentiallyApplicable = new ArrayList<JMethodSig>();
        for (JMethodSig it : ((ExprMirror.InvocationMirror)site.getExpr()).getAccessibleCandidates()) {
            if (!this.isPotentiallyApplicable(it, (ExprMirror.InvocationMirror)site.getExpr())) continue;
            potentiallyApplicable.add(it);
        }
        if (potentiallyApplicable.isEmpty()) {
            this.LOG.noApplicableCandidates(site);
            return this.NO_CTDECL;
        }
        for (MethodResolutionPhase phase : MethodResolutionPhase.APPLICABILITY_TESTS) {
            PhaseOverloadSet applicable = new PhaseOverloadSet(this, phase, site);
            for (JMethodSig m : potentiallyApplicable) {
                site.resetInferenceData();
                ExprMirror.InvocationMirror.MethodCtDecl candidate = this.logInference(site, phase, m);
                if (candidate.isFailed()) continue;
                applicable.add(candidate);
            }
            if (!applicable.nonEmpty()) continue;
            ExprMirror.InvocationMirror.MethodCtDecl bestApplicable = applicable.getMostSpecificOrLogAmbiguity(this.LOG);
            JMethodSig adapted = ExprOps.adaptGetClass(bestApplicable.getMethodType(), ((ExprMirror.InvocationMirror)site.getExpr())::getErasedReceiverType);
            return bestApplicable.withMethod(adapted);
        }
        this.LOG.noCompileTimeDeclaration(site);
        return this.NO_CTDECL;
    }

    @NonNull ExprMirror.InvocationMirror.MethodCtDecl finishInstantiation(MethodCallSite site, ExprMirror.InvocationMirror.MethodCtDecl ctdecl) {
        JMethodSig m = ctdecl.getMethodType();
        ExprMirror.InvocationMirror expr = (ExprMirror.InvocationMirror)site.getExpr();
        site.loadInferenceData(ctdecl);
        site.setInInvocation();
        if (site.canSkipInvocation()) {
            assert (this.assertReturnIsGround(m));
            expr.setInferredType(m.getReturnType());
            this.LOG.skipInstantiation(m, site);
            return ctdecl;
        }
        return this.logInference(site, ctdecl.getResolvePhase().asInvoc(), ctdecl.getMethodType().internalApi().adaptedMethod());
    }

    private boolean assertReturnIsGround(JMethodSig t) {
        TypeOps.subst(t.getReturnType(), var -> {
            assert (!(var instanceof InferenceVar)) : "Expected a ground type " + t;
            assert (!(var instanceof JTypeVar) || !t.getTypeParameters().contains(var)) : "Some type parameters have not been instantiated";
            return var;
        });
        return true;
    }

    private @NonNull ExprMirror.InvocationMirror.MethodCtDecl logInference(MethodCallSite site, MethodResolutionPhase phase, JMethodSig m) {
        this.LOG.startInference(m, site, phase);
        @Nullable JMethodSig candidate = this.instantiateMethodOrCtor(site, phase, m);
        this.LOG.endInference(candidate);
        if (candidate == null) {
            return this.FAILED_INVOCATION;
        }
        return new ExprMirror.InvocationMirror.MethodCtDecl(candidate, phase, site.canSkipInvocation(), site.needsUncheckedConversion(), false);
    }

    private @Nullable JMethodSig instantiateMethodOrCtor(MethodCallSite site, MethodResolutionPhase phase, JMethodSig m) {
        return site.getExpr() instanceof ExprMirror.CtorInvocationMirror ? this.instantiateConstructor(m, site, phase) : this.instantiateMethod(m, site, phase);
    }

    private @Nullable JMethodSig instantiateMethod(JMethodSig m, MethodCallSite site, MethodResolutionPhase phase) {
        if (phase.requiresVarargs() && !m.isVarargs()) {
            return null;
        }
        try {
            return this.instantiateMaybeNoInfer(m, site, phase);
        }
        catch (ResolutionFailedException e) {
            ResolutionFailure failure = e.getFailure();
            failure.addContext(m, site, phase);
            this.LOG.logResolutionFail(failure);
            return null;
        }
    }

    private @Nullable JMethodSig instantiateConstructor(JMethodSig cons, MethodCallSite site, MethodResolutionPhase phase) {
        ExprMirror.CtorInvocationMirror expr = (ExprMirror.CtorInvocationMirror)site.getExpr();
        JTypeMirror newTypeMaybeInvalid = expr.getNewType();
        if (!(newTypeMaybeInvalid instanceof JClassType)) {
            return null;
        }
        JClassType newType = (JClassType)newTypeMaybeInvalid;
        boolean isAdapted = this.needsAdaptation(expr, newType);
        JMethodSig adapted = isAdapted ? Infer.adaptGenericConstructor(cons, newType, expr) : cons;
        site.maySkipInvocation(!isAdapted);
        @Nullable JMethodSig result = this.instantiateMethod(adapted, site, phase);
        if (isAdapted && result != null) {
            JTypeMirror rtype = result.getReturnType();
            if (!rtype.isInterface()) {
                result = result.internalApi().withOwner(rtype);
            }
            return result.internalApi().withTypeParams(null);
        }
        return result;
    }

    private boolean needsAdaptation(ExprMirror.CtorInvocationMirror expr, JClassType newType) {
        return expr.isDiamond() || newType.isParameterizedType() || expr.isAnonymous();
    }

    private static JMethodSig adaptGenericConstructor(JMethodSig cons, JClassType newType, ExprMirror.CtorInvocationMirror expr) {
        assert (cons.isConstructor()) : cons + " should be a constructor";
        if (cons.getDeclaringType().isArray()) {
            return cons;
        }
        JMethodSig adaptedSig = cons.internalApi().withReturnType(newType).internalApi().markAsAdapted();
        List<JTypeVar> newTypeFormals = newType.getFormalTypeParams();
        if (newTypeFormals.isEmpty()) {
            return adaptedSig;
        }
        List<JTypeVar> consParams = cons.getTypeParameters();
        if (consParams.size() > cons.getSymbol().getTypeParameterCount()) {
            assert (consParams.equals(CollectionUtil.concatView(cons.getSymbol().getTypeParameters(), newTypeFormals)));
            return adaptedSig;
        }
        if (!expr.isDiamond()) {
            return adaptedSig;
        }
        List tparams = CollectionUtil.concatView(consParams, newTypeFormals);
        return adaptedSig.internalApi().withTypeParams(tparams).internalApi().markAsAdapted();
    }

    private JMethodSig instantiateMaybeNoInfer(JMethodSig m, MethodCallSite site, MethodResolutionPhase phase) {
        if (!m.isGeneric()) {
            this.addArgsConstraints(this.emptyContext(), m, site, phase);
            return m;
        }
        ExprMirror.InvocationMirror expr = (ExprMirror.InvocationMirror)site.getExpr();
        List<JTypeMirror> explicitTargs = expr.getExplicitTypeArguments();
        if (!explicitTargs.isEmpty()) {
            List<JTypeVar> tparams = m.getTypeParameters();
            if (tparams.size() != explicitTargs.size()) {
                throw ResolutionFailedException.incompatibleTypeParamCount(this.LOG, site.getExpr(), m, explicitTargs.size(), tparams.size());
            }
            Substitution explicitSubst = Substitution.mapping(tparams, explicitTargs);
            for (int i = 0; i < tparams.size(); ++i) {
                JTypeVisitable upperBound;
                JTypeMirror explicit = explicitTargs.get(i);
                if (!explicit.isConvertibleTo((JTypeMirror)(upperBound = tparams.get(i).getUpperBound().subst((Function)explicitSubst))).never()) continue;
                throw ResolutionFailedException.incompatibleBound(this.LOG, explicit, (JTypeMirror)upperBound, expr.getExplicitTargLoc(i));
            }
            JTypeVisitable subst = m.subst((Function)explicitSubst);
            this.addArgsConstraints(this.emptyContext(), (JMethodSig)subst, site, phase);
            return subst;
        }
        site.maySkipInvocation(!ExprOps.isContextDependent(m) && site.getOuterCtx().isGround(m.getReturnType()));
        return this.instantiateImpl(m, site, phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMethodSig instantiateImpl(JMethodSig m, MethodCallSite site, MethodResolutionPhase phase) {
        InferenceContext infCtx = this.newContextFor(m);
        this.LOG.ctxInitialization(infCtx, m);
        try {
            boolean shouldPropagate;
            if (phase.isInvocation() && !this.isPreJava8) {
                m = this.doReturnChecksAndChangeReturnType(m, site, infCtx);
            }
            this.addArgsConstraints(infCtx, m, site, phase);
            infCtx.incorporate();
            if (phase.isInvocation() && (shouldPropagate = this.shouldPropagateOutwards(m.getReturnType(), site, infCtx))) {
                this.LOG.propagateAndAbort(infCtx, site.getOuterCtx());
                infCtx.duplicateInto(site.getOuterCtx());
                JMethodSig jMethodSig = infCtx.mapToIVars(m);
                return jMethodSig;
            }
            boolean isDone = infCtx.solve(this.isPreJava8());
            if (this.isPreJava8() && !isDone) {
                if (site.getOuterCtx().isEmpty()) {
                    m = this.doReturnChecksAndChangeReturnType(m, site, infCtx);
                }
                infCtx.solve();
            }
            if (infCtx.needsUncheckedConversion()) {
                site.setNeedsUncheckedConversion();
            }
            JMethodSig jMethodSig = InferenceContext.finalGround(infCtx.mapToIVars(m));
            return jMethodSig;
        }
        finally {
            infCtx.callListeners();
        }
    }

    private JMethodSig doReturnChecksAndChangeReturnType(JMethodSig m, MethodCallSite site, InferenceContext infCtx) {
        this.LOG.startReturnChecks();
        JTypeMirror actualResType = this.addReturnConstraints(infCtx, m, site);
        this.LOG.endReturnChecks();
        m = m.internalApi().withReturnType(actualResType);
        return m;
    }

    private boolean shouldPropagateOutwards(JTypeMirror resultType, MethodCallSite target, InferenceContext inferenceContext) {
        return !this.isPreJava8 && !target.getOuterCtx().isEmpty() && !inferenceContext.isGround(resultType) && (!(resultType instanceof InferenceVar) || !this.needsEagerInstantiation((InferenceVar)resultType, target.getExpectedType(), inferenceContext));
    }

    private JTypeMirror addReturnConstraints(InferenceContext infCtx, JMethodSig m, MethodCallSite site) {
        JTypeMirror actualRes;
        JTypeMirror resultType = m.getReturnType();
        if (site.needsUncheckedConversion()) {
            resultType = resultType.getErasure();
        }
        resultType = infCtx.mapToIVars(resultType);
        InferenceContext outerInfCtx = site.getOuterCtx();
        if (!infCtx.isGround(resultType) && !outerInfCtx.isEmpty() && resultType instanceof JClassType) {
            JClassType resClass = TypeConversion.capture((JClassType)resultType);
            resultType = resClass;
            for (JTypeMirror targ : resClass.getTypeArgs()) {
                if (!(targ instanceof JTypeVar) || !((JTypeVar)targ).isCaptured()) continue;
                infCtx.addVar((JTypeVar)targ);
            }
            resultType = infCtx.mapToIVars(resultType);
        }
        if ((actualRes = site.getExpectedType()) == null) {
            actualRes = this.ts.OBJECT;
        }
        if (resultType instanceof InferenceVar) {
            InferenceVar retVar = (InferenceVar)resultType;
            if (this.needsEagerInstantiation(retVar, actualRes, infCtx)) {
                infCtx.solve(retVar);
                infCtx.callListeners();
                if (Infer.isConvertible(retVar.getInst(), actualRes, true).never()) {
                    actualRes = this.ts.OBJECT;
                }
            } else if (actualRes.isPrimitive()) {
                actualRes = actualRes.box();
            }
        }
        if (Infer.isConvertible(resultType, outerInfCtx.mapToIVars(actualRes), true).never()) {
            throw ResolutionFailedException.incompatibleReturn(this.LOG, site.getExpr(), resultType, actualRes);
        }
        return resultType;
    }

    private boolean needsEagerInstantiation(InferenceVar alpha, JTypeMirror t, InferenceContext infCtx) {
        if (t == null) {
            return false;
        }
        if (t.isPrimitive()) {
            for (JTypeMirror b : alpha.getBounds(InferenceVar.BoundKind.ALL)) {
                if (!b.isBoxedPrimitive()) continue;
                return true;
            }
            return false;
        }
        if (!t.isPrimitive() && !TypeConversion.isWilcardParameterized(t)) {
            for (JTypeMirror s : alpha.getBounds(InferenceVar.BoundKind.EQ_LOWER)) {
                if (!TypeConversion.isWilcardParameterized(s)) continue;
                return true;
            }
            for (JTypeMirror aLowerBound : alpha.getBounds(InferenceVar.BoundKind.LOWER)) {
                for (JTypeMirror anotherLowerBound : alpha.getBounds(InferenceVar.BoundKind.LOWER)) {
                    if (aLowerBound == anotherLowerBound || !infCtx.isGround(aLowerBound) || !infCtx.isGround(anotherLowerBound) || !this.commonSuperWithDiffParameterization(aLowerBound, anotherLowerBound)) continue;
                    return true;
                }
            }
        }
        if (t.isParameterizedType()) {
            for (JTypeMirror b : alpha.getBounds(InferenceVar.BoundKind.EQ_LOWER)) {
                JTypeMirror sup = b.getAsSuper(((JClassType)t).getSymbol());
                if (sup == null || !sup.isRaw()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean commonSuperWithDiffParameterization(JTypeMirror t, JTypeMirror s) {
        JTypeMirror lubResult = this.ts.lub(CollectionUtil.listOf((Object)t, (Object[])new JTypeMirror[]{s}));
        if (lubResult.isBottom() || lubResult.isTop()) {
            return false;
        }
        for (JTypeMirror sup : TypeOps.asList(lubResult)) {
            if (!sup.isParameterizedType()) continue;
            JClassSymbol sym = ((JClassType)sup).getSymbol();
            JTypeMirror asSuperOfT = t.getAsSuper(sym);
            JTypeMirror asSuperOfS = s.getAsSuper(sym);
            if (asSuperOfS.equals(asSuperOfT)) continue;
            return true;
        }
        return false;
    }

    private void addArgsConstraints(InferenceContext infCtx, JMethodSig m, MethodCallSite site, MethodResolutionPhase phase) {
        this.LOG.startArgsChecks();
        ExprMirror.InvocationMirror expr = (ExprMirror.InvocationMirror)site.getExpr();
        boolean varargsRequired = phase.requiresVarargs();
        if (!varargsRequired && m.getArity() != expr.getArgumentCount()) {
            throw ResolutionFailedException.incompatibleArity(this.LOG, expr.getArgumentCount(), m.getArity(), expr);
        }
        List<JTypeMirror> fs = m.getFormalParameters();
        JArrayType varargsParam = varargsRequired && m.isVarargs() ? (JArrayType)fs.get(fs.size() - 1) : null;
        int lastP = varargsParam == null ? fs.size() : fs.size() - 1;
        List<ExprMirror> args = expr.getArgumentExpressions();
        for (int i = 0; i < lastP; ++i) {
            ExprMirror ei = args.get(i);
            if (phase.isInvocation() || ExprOps.isPertinentToApplicability(ei, m, fs.get(i), expr)) {
                JTypeMirror stdType = ei.getStandaloneType();
                JTypeMirror fi = infCtx.mapToIVars(fs.get(i));
                this.LOG.startArg(i, ei, fi);
                if (!phase.canBox() && stdType != null && stdType.isPrimitive() != fi.isPrimitive() && stdType != this.ts.UNKNOWN) {
                    throw ResolutionFailedException.incompatibleFormal(this.LOG, ei, stdType, fi);
                }
                this.addBoundOrDefer(site, infCtx, phase, ei, fi);
                this.LOG.endArg();
                continue;
            }
            site.maySkipInvocation(false);
            this.LOG.skipArgAsNonPertinent(i, ei);
        }
        if (varargsRequired && varargsParam != null) {
            JTypeMirror varargsComponent = infCtx.mapToIVars(varargsParam.getComponentType());
            for (int i = lastP; i < args.size(); ++i) {
                ExprMirror ei = args.get(i);
                if (phase.isInvocation() || ExprOps.isPertinentToApplicability(ei, m, varargsComponent, expr)) {
                    this.LOG.startArg(i, ei, varargsComponent);
                    this.addBoundOrDefer(site, infCtx, phase, ei, varargsComponent);
                    this.LOG.endArg();
                    continue;
                }
                site.maySkipInvocation(false);
                this.LOG.skipArgAsNonPertinent(i, ei);
            }
        }
        this.LOG.endArgsChecks();
    }

    private void addBoundOrDefer(@Nullable MethodCallSite site, InferenceContext infCtx, MethodResolutionPhase phase, @NonNull ExprMirror arg, @NonNull JTypeMirror formalType) {
        ExprCheckHelper.ExprChecker exprChecker = (ctx, exprType, formalType1) -> this.checkConvertibleOrDefer(ctx, exprType, formalType1, arg, phase, site);
        ExprCheckHelper helper = new ExprCheckHelper(infCtx, phase, exprChecker, site, this);
        if (!helper.isCompatible(formalType, arg)) {
            throw ResolutionFailedException.incompatibleFormalExprNoReason(this.LOG, arg, formalType);
        }
    }

    void checkConvertibleOrDefer(InferenceContext infCtx, JTypeMirror exprType, JTypeMirror formalType, ExprMirror arg, MethodResolutionPhase phase, @Nullable MethodCallSite site) {
        JTypeMirror groundF;
        JTypeMirror groundE;
        TypeOps.Convertibility isConvertible;
        if (!infCtx.isGround(formalType) || !infCtx.isGround(exprType)) {
            infCtx.addInstantiationListener(CollectionUtil.setOf((Object)formalType, (Object[])new JTypeMirror[]{exprType}), solvedCtx -> this.checkConvertibleOrDefer(solvedCtx, exprType, formalType, arg, phase, site));
        }
        if ((isConvertible = Infer.isConvertible(groundE = infCtx.ground(exprType), groundF = infCtx.ground(formalType), phase.canBox())).never()) {
            throw ResolutionFailedException.incompatibleFormal(this.LOG, arg, groundE, groundF);
        }
        if (isConvertible.withUncheckedWarning() && site != null) {
            site.setNeedsUncheckedConversion();
        }
    }

    static TypeOps.Convertibility isConvertible(JTypeMirror exprType, JTypeMirror formalType, boolean canBox) {
        if (exprType == formalType) {
            return TypeOps.Convertibility.SUBTYPING;
        }
        if (canBox && exprType.isPrimitive() ^ formalType.isPrimitive()) {
            TypeOps.Convertibility result = TypeOps.isConvertible(exprType.box(), formalType.box());
            if (!result.never()) {
                return result;
            }
            return TypeOps.isConvertible(exprType.unbox(), formalType.unbox());
        }
        return TypeOps.isConvertible(exprType, formalType);
    }

    private boolean isPotentiallyApplicable(JMethodSig m, ExprMirror.InvocationMirror expr) {
        block9: {
            List<ExprMirror> args;
            block8: {
                if (m.isGeneric() && !expr.getExplicitTypeArguments().isEmpty() && expr.getExplicitTypeArguments().size() != m.getTypeParameters().size()) {
                    return false;
                }
                args = expr.getArgumentExpressions();
                if (m.isVarargs()) break block8;
                if (args.size() != m.getArity()) {
                    return false;
                }
                List<JTypeMirror> fs = m.getFormalParameters();
                for (int i = 0; i < args.size(); ++i) {
                    if (this.exprOps.isPotentiallyCompatible(m, args.get(i), fs.get(i))) continue;
                    return false;
                }
                break block9;
            }
            List<JTypeMirror> fs = m.getFormalParameters();
            int varargIdx = fs.size() - 1;
            for (int i = 0; i < varargIdx; ++i) {
                if (i >= args.size()) {
                    return false;
                }
                if (this.exprOps.isPotentiallyCompatible(m, args.get(i), fs.get(i))) continue;
                return false;
            }
            if (args.size() == varargIdx - 1) {
                return true;
            }
            if (args.size() == fs.size()) {
                JArrayType t;
                ExprMirror last = args.get(varargIdx);
                return this.exprOps.isPotentiallyCompatible(m, last, t = (JArrayType)fs.get(varargIdx)) || this.exprOps.isPotentiallyCompatible(m, last, t.getComponentType());
            }
            if (args.size() <= fs.size()) break block9;
            JTypeMirror t = ((JArrayType)fs.get(varargIdx)).getComponentType();
            for (int i = varargIdx; i < args.size(); ++i) {
                if (this.exprOps.isPotentiallyCompatible(m, args.get(i), t)) continue;
                return false;
            }
        }
        return true;
    }
}

