/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.EmptyClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BasePrimitiveSymbol
extends EmptyClassSymbol
implements JClassSymbol {
    BasePrimitiveSymbol(TypeSystem ts) {
        super(() -> ts);
    }

    @Override
    public @NonNull String getPackageName() {
        return "java.lang";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public int getModifiers() {
        return 1041;
    }

    public int hashCode() {
        return SymbolEquality.CLASS.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SymbolEquality.CLASS.equals(this, obj);
    }

    public String toString() {
        return SymbolToStrings.SHARED.toString(this);
    }

    static final class RealPrimitiveSymbol
    extends BasePrimitiveSymbol {
        private final JPrimitiveType.PrimitiveTypeKind kind;

        RealPrimitiveSymbol(TypeSystem ts, JPrimitiveType.PrimitiveTypeKind kind) {
            super(ts);
            this.kind = kind;
        }

        @Override
        public @NonNull String getBinaryName() {
            return this.kind.getSimpleName();
        }

        @Override
        public @Nullable String getCanonicalName() {
            return this.kind.getSimpleName();
        }

        @Override
        public @NonNull String getSimpleName() {
            return this.kind.getSimpleName();
        }
    }

    static final class VoidSymbol
    extends BasePrimitiveSymbol {
        VoidSymbol(TypeSystem ts) {
            super(ts);
        }

        @Override
        public @NonNull String getBinaryName() {
            return "void";
        }

        @Override
        public String getCanonicalName() {
            return "void";
        }

        @Override
        public @NonNull String getSimpleName() {
            return "void";
        }
    }
}

