/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;

public class GetCommentOnFunction
extends BaseJavaXPathFunction {
    public static final GetCommentOnFunction INSTANCE = new GetCommentOnFunction();

    protected GetCommentOnFunction() {
        super("getCommentOn");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[0];
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_STRING;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext context, Sequence[] arguments) {
                Node contextNode = ((AstElementNode)context.getContextItem()).getUnderlyingNode();
                int codeBeginLine = contextNode.getBeginLine();
                int codeEndLine = contextNode.getEndLine();
                List<JavaComment> commentList = ((ASTCompilationUnit)contextNode.getFirstParentOfType(ASTCompilationUnit.class)).getComments();
                for (JavaComment comment : commentList) {
                    if (comment.getBeginLine() != codeBeginLine && comment.getEndLine() != codeEndLine) continue;
                    return new StringValue((CharSequence)comment.getText());
                }
                return EmptyAtomicSequence.INSTANCE;
            }
        };
    }
}

