/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class InefficientEmptyStringCheckRule
extends AbstractJavaRulechainRule {
    public InefficientEmptyStringCheckRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodCall call, Object data) {
        if (InefficientEmptyStringCheckRule.isTrimCall(call.getQualifier()) && (InefficientEmptyStringCheckRule.isLengthZeroCheck(call) || InefficientEmptyStringCheckRule.isIsEmptyCall(call))) {
            this.addViolation(data, (Node)call);
        }
        return null;
    }

    private static boolean isLengthZeroCheck(ASTMethodCall call) {
        return "length".equals(call.getMethodName()) && call.getArguments().size() == 0 && JavaRuleUtil.isZeroChecked(call);
    }

    private static boolean isTrimCall(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            return "trim".equals(call.getMethodName()) && call.getArguments().size() == 0 && TypeTestUtil.isA(String.class, (TypeNode)call.getQualifier());
        }
        return false;
    }

    private static boolean isIsEmptyCall(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            return "isEmpty".equals(call.getMethodName()) && call.getArguments().size() == 0;
        }
        return false;
    }
}

