/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AssignmentInOperandRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> ALLOW_IF_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIf").desc("Allow assignment within the conditional expression of an if statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_FOR_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowFor").desc("Allow assignment within the conditional expression of a for statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_WHILE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowWhile").desc("Allow assignment within the conditional expression of a while statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_INCREMENT_DECREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIncrementDecrement").desc("Allow increment or decrement operators within the conditional expression of an if, for, or while statement")).defaultValue((Object)false)).build();

    public AssignmentInOperandRule() {
        super(ASTAssignmentExpression.class, ASTUnaryExpression.class);
        this.definePropertyDescriptor(ALLOW_IF_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_FOR_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_WHILE_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTAssignmentExpression node, Object data) {
        this.checkAssignment(node, (RuleContext)data);
        return null;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        if (!((Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR)).booleanValue() && !node.getOperator().isPure()) {
            this.checkAssignment(node, (RuleContext)data);
        }
        return null;
    }

    private void checkAssignment(ASTExpression impureExpr, RuleContext ctx) {
        ASTExpression toplevel = JavaAstUtils.getTopLevelExpr(impureExpr);
        JavaNode parent = (JavaNode)toplevel.getParent();
        if (parent instanceof ASTExpressionStatement) {
            return;
        }
        if (parent instanceof ASTIfStatement && (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) == false || parent instanceof ASTWhileStatement && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) == false || parent instanceof ASTForStatement && ((ASTForStatement)parent).getCondition() == toplevel && !((Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR)).booleanValue()) {
            this.addViolation(ctx, (Node)impureExpr);
        }
    }

    public boolean allowsAllAssignments() {
        return (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR) != false;
    }

    public String dysfunctionReason() {
        return this.allowsAllAssignments() ? "All assignment types allowed, no checks performed" : null;
    }
}

