/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.AssertionUtil;

public final class UselessParenthesesRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_CLARIFYING = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreClarifying").defaultValue((Object)true)).desc("Ignore parentheses that separate expressions of difference precedence, like in `(a % 2 == 0) ? x : -x`")).build();
    private static final PropertyDescriptor<Boolean> IGNORE_BALANCING = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreBalancing").defaultValue((Object)true)).desc("Ignore unnecessary parentheses that appear balanced around an equality operator, because the other operand requires parentheses.For example, in `(a == null) == (b == null)`, only the second pair of parentheses is necessary, but the expression is clearer that way.")).build();

    public UselessParenthesesRule() {
        super(ASTExpression.class, new Class[0]);
        this.definePropertyDescriptor(IGNORE_CLARIFYING);
        this.definePropertyDescriptor(IGNORE_BALANCING);
    }

    private boolean reportClarifying() {
        return (Boolean)this.getProperty(IGNORE_CLARIFYING) == false;
    }

    private boolean reportBalancing() {
        return (Boolean)this.getProperty(IGNORE_BALANCING) == false;
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        if (!(node instanceof ASTExpression)) {
            throw new IllegalArgumentException("Expected an expression, got " + node);
        }
        this.checkExpr((ASTExpression)node, data);
        return null;
    }

    private void checkExpr(ASTExpression e, Object data) {
        if (!e.isParenthesized()) {
            return;
        }
        Necessity necessity = UselessParenthesesRule.needsParentheses(e, (JavaNode)e.getParent());
        if (necessity == Necessity.NEVER || this.reportClarifying() && necessity == Necessity.CLARIFYING || this.reportBalancing() && necessity == Necessity.BALANCING) {
            this.addViolation(data, (Node)e);
        }
    }

    static Necessity needsParentheses(ASTExpression inner, JavaNode outer) {
        assert (inner.isParenthesized()) : inner + " is not parenthesized";
        if (inner.getParenthesisDepth() > 1 || !(outer instanceof ASTExpression)) {
            return Necessity.NEVER;
        }
        if (inner instanceof ASTPrimaryExpression || inner instanceof ASTSwitchExpression) {
            return Necessity.NEVER;
        }
        if (outer instanceof ASTLambdaExpression) {
            if (inner instanceof ASTLambdaExpression) {
                return Necessity.NEVER;
            }
            return Necessity.definitely(inner instanceof ASTConditionalExpression && outer.getParent() instanceof ASTConditionalExpression);
        }
        if (inner instanceof ASTAssignmentExpression) {
            return outer instanceof ASTAssignmentExpression ? Necessity.NEVER : Necessity.ALWAYS;
        }
        if (inner instanceof ASTConditionalExpression) {
            if (outer instanceof ASTConditionalExpression) {
                return inner.getIndexInParent() == 2 ? Necessity.NEVER : Necessity.ALWAYS;
            }
            return Necessity.necessaryIf(!(outer instanceof ASTAssignmentExpression));
        }
        if (inner instanceof ASTLambdaExpression) {
            return outer instanceof ASTConditionalExpression ? Necessity.CLARIFYING : Necessity.definitely(!(outer instanceof ASTAssignmentExpression));
        }
        if (inner instanceof ASTInfixExpression) {
            if (outer instanceof ASTInfixExpression) {
                BinaryOp inop = ((ASTInfixExpression)inner).getOperator();
                BinaryOp outop = ((ASTInfixExpression)outer).getOperator();
                int comp = outop.comparePrecedence(inop);
                if (comp > 0) {
                    return Necessity.ALWAYS;
                }
                if (comp < 0) {
                    return Necessity.CLARIFYING;
                }
                if (inner.getIndexInParent() == 1) {
                    if (UselessParenthesesRule.associatesRightWith(outop, inop, (ASTInfixExpression)inner, (ASTInfixExpression)outer)) {
                        return Necessity.NEVER;
                    }
                    return Necessity.ALWAYS;
                }
                if (outop.hasSamePrecedenceAs(BinaryOp.EQ) && ((ASTInfixExpression)outer).getRightOperand().isParenthesized()) {
                    return Necessity.BALANCING;
                }
                if (outop == BinaryOp.ADD && inop.hasSamePrecedenceAs(BinaryOp.ADD) && inner.getTypeMirror().isNumeric() && !((ASTInfixExpression)outer).getTypeMirror().isNumeric()) {
                    return Necessity.CLARIFYING;
                }
                return Necessity.NEVER;
            }
            if (outer instanceof ASTConditionalExpression && inner.getIndexInParent() == 0) {
                return Necessity.CLARIFYING;
            }
            return Necessity.necessaryIf(UselessParenthesesRule.isUnary(outer) || outer instanceof ASTPrimaryExpression);
        }
        if (UselessParenthesesRule.isUnary(inner)) {
            return UselessParenthesesRule.isUnary(outer) ? Necessity.NEVER : Necessity.necessaryIf(outer instanceof ASTPrimaryExpression);
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unhandled case inside " + outer));
    }

    private static boolean isUnary(JavaNode expr) {
        return expr instanceof ASTUnaryExpression || expr instanceof ASTCastExpression;
    }

    private static boolean associatesRightWith(BinaryOp outop, BinaryOp inop, ASTInfixExpression inner, ASTInfixExpression outer) {
        switch (inop) {
            case AND: 
            case OR: 
            case XOR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return true;
            }
            case MUL: {
                return inop == outop;
            }
            case SUB: 
            case ADD: {
                return outop == BinaryOp.ADD && outer.getTypeMirror().isPrimitive() == inner.getTypeMirror().isPrimitive() && !inner.getTypeMirror().isFloatingPoint();
            }
        }
        return false;
    }

    static enum Necessity {
        ALWAYS,
        NEVER,
        CLARIFYING,
        BALANCING;


        static Necessity definitely(boolean b) {
            return b ? ALWAYS : NEVER;
        }

        static Necessity necessaryIf(boolean b) {
            return b ? ALWAYS : CLARIFYING;
        }
    }
}

