/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CycloVisitor
extends JavaVisitorBase<MutableInt, Void> {
    protected final boolean considerBooleanPaths;
    protected final boolean considerAssert;
    private final JavaNode topNode;

    public CycloVisitor(MetricOptions options, JavaNode topNode) {
        this.considerBooleanPaths = !options.getOptions().contains((Object)JavaMetrics.CycloOption.IGNORE_BOOLEAN_PATHS);
        this.considerAssert = options.getOptions().contains((Object)JavaMetrics.CycloOption.CONSIDER_ASSERT);
        this.topNode = topNode;
    }

    @Override
    public final Void visitJavaNode(JavaNode localNode, MutableInt data) {
        return localNode.isFindBoundary() && !localNode.equals(this.topNode) ? null : (Void)super.visitJavaNode(localNode, (Object)data);
    }

    @Override
    public Void visit(ASTSwitchExpression node, MutableInt data) {
        return this.handleSwitch(node, data);
    }

    @Override
    public Void visit(ASTSwitchStatement node, MutableInt data) {
        return this.handleSwitch(node, data);
    }

    private Void handleSwitch(ASTSwitchLike node, MutableInt data) {
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getTestedExpression()));
        }
        for (ASTSwitchBranch branch : node) {
            if (branch.getLabel().isDefault()) continue;
            if (this.considerBooleanPaths) {
                data.add(JavaAstUtils.numAlternatives(branch));
                continue;
            }
            if (!(branch instanceof ASTSwitchFallthroughBranch) || !((ASTSwitchFallthroughBranch)branch).getStatements().nonEmpty()) continue;
            data.increment();
        }
        return this.visitJavaNode((JavaNode)node, data);
    }

    @Override
    public Void visit(ASTConditionalExpression node, MutableInt data) {
        data.increment();
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTWhileStatement node, MutableInt data) {
        data.increment();
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTIfStatement node, MutableInt data) {
        data.increment();
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTForStatement node, MutableInt data) {
        data.increment();
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTForeachStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visitMethodOrCtor(ASTMethodOrConstructorDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visitMethodOrCtor(node, data);
    }

    @Override
    public Void visit(ASTDoStatement node, MutableInt data) {
        data.increment();
        if (this.considerBooleanPaths) {
            data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTCatchClause node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTThrowStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTAssertStatement node, MutableInt data) {
        if (this.considerAssert) {
            data.add(2);
            if (this.considerBooleanPaths) {
                data.add(CycloVisitor.booleanExpressionComplexity(node.getCondition()));
            }
        }
        return (Void)super.visit(node, data);
    }

    public static int booleanExpressionComplexity(@Nullable ASTExpression expr) {
        if (expr == null) {
            return 0;
        }
        if (expr instanceof ASTConditionalExpression) {
            ASTConditionalExpression conditional = (ASTConditionalExpression)expr;
            return CycloVisitor.booleanExpressionComplexity(conditional.getCondition()) + CycloVisitor.booleanExpressionComplexity(conditional.getThenBranch()) + CycloVisitor.booleanExpressionComplexity(conditional.getElseBranch()) + 2;
        }
        return expr.descendantsOrSelf().filter(JavaAstUtils::isConditional).count();
    }
}

