/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompactConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaExpr;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.util.designerbindings.DesignerBindings;
import net.sourceforge.pmd.util.designerbindings.RelatedNodesSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class JavaDesignerBindings
extends DesignerBindings.DefaultDesignerBindings {
    public static final JavaDesignerBindings INSTANCE = new JavaDesignerBindings();

    private JavaDesignerBindings() {
    }

    public Attribute getMainAttribute(Node node) {
        Attribute attr;
        if (node instanceof JavaNode && (attr = (Attribute)node.acceptVisitor((AstVisitor)MainAttrVisitor.INSTANCE, null)) != null) {
            return attr;
        }
        return super.getMainAttribute(node);
    }

    public DesignerBindings.TreeIconId getIcon(Node node) {
        if (node instanceof ASTFieldDeclaration) {
            return DesignerBindings.TreeIconId.FIELD;
        }
        if (node instanceof ASTAnyTypeDeclaration) {
            return DesignerBindings.TreeIconId.CLASS;
        }
        if (node instanceof ASTMethodDeclaration) {
            return DesignerBindings.TreeIconId.METHOD;
        }
        if (node instanceof ASTConstructorDeclaration || node instanceof ASTCompactConstructorDeclaration) {
            return DesignerBindings.TreeIconId.CONSTRUCTOR;
        }
        if (node instanceof ASTVariableDeclaratorId) {
            return DesignerBindings.TreeIconId.VARIABLE;
        }
        return super.getIcon(node);
    }

    public Collection<DesignerBindings.AdditionalInfo> getAdditionalInfo(Node node) {
        AbstractJavaExpr lambda;
        ArrayList<DesignerBindings.AdditionalInfo> info = new ArrayList<DesignerBindings.AdditionalInfo>(super.getAdditionalInfo(node));
        if (node instanceof ASTLambdaExpression) {
            lambda = (ASTLambdaExpression)node;
            info.add(new DesignerBindings.AdditionalInfo("Function type: " + ((ASTLambdaExpression)lambda).getFunctionalMethod()));
        }
        if (node instanceof ASTMethodReference) {
            lambda = (ASTMethodReference)node;
            info.add(new DesignerBindings.AdditionalInfo("Function type: " + ((ASTMethodReference)lambda).getFunctionalMethod()));
            info.add(new DesignerBindings.AdditionalInfo("CTDecl: " + ((ASTMethodReference)lambda).getReferencedMethod()));
        }
        if (node instanceof InvocationNode) {
            InvocationNode invoc = (InvocationNode)node;
            info.add(new DesignerBindings.AdditionalInfo("Function: " + invoc.getMethodType()));
            info.add(new DesignerBindings.AdditionalInfo("VarargsCall: " + invoc.getOverloadSelectionInfo().isVarargsCall()));
            info.add(new DesignerBindings.AdditionalInfo("Unchecked: " + invoc.getOverloadSelectionInfo().needsUncheckedConversion()));
            info.add(new DesignerBindings.AdditionalInfo("Failed: " + invoc.getOverloadSelectionInfo().isFailed()));
        }
        if (node instanceof TypeNode) {
            JTypeMirror typeMirror = ((TypeNode)node).getTypeMirror();
            info.add(new DesignerBindings.AdditionalInfo("Type: " + typeMirror));
        }
        if (node instanceof AccessNode) {
            String effective = this.formatModifierSet(((AccessNode)node).getModifiers().getEffectiveModifiers());
            String explicit = this.formatModifierSet(((AccessNode)node).getModifiers().getExplicitModifiers());
            info.add(new DesignerBindings.AdditionalInfo("pmd-java:modifiers(): " + effective));
            info.add(new DesignerBindings.AdditionalInfo("pmd-java:explicitModifiers(): " + explicit));
        }
        return info;
    }

    private @NonNull String formatModifierSet(Set<JModifier> modifierSet) {
        return modifierSet.stream().map(JModifier::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    public RelatedNodesSelector getRelatedNodesSelector() {
        return n -> {
            JVariableSymbol sym;
            if (n instanceof ASTAssignableExpr.ASTNamedReferenceExpr && (sym = ((ASTAssignableExpr.ASTNamedReferenceExpr)n).getReferencedSym()) != null && sym.tryGetNode() != null) {
                return Collections.unmodifiableList(((ASTVariableDeclaratorId)sym.tryGetNode()).getLocalUsages());
            }
            return Collections.emptyList();
        };
    }

    private static final class MainAttrVisitor
    extends JavaVisitorBase<Void, Attribute> {
        private static final MainAttrVisitor INSTANCE = new MainAttrVisitor();

        private MainAttrVisitor() {
        }

        @Override
        public Attribute visitJavaNode(JavaNode node, Void data) {
            return null;
        }

        @Override
        public Attribute visit(ASTInfixExpression node, Void data) {
            return new Attribute((Node)node, "Operator", node.getOperator().toString());
        }

        @Override
        public Attribute visitTypeDecl(ASTAnyTypeDeclaration node, Void data) {
            return new Attribute((Node)node, "SimpleName", node.getSimpleName());
        }

        @Override
        public Attribute visit(ASTAnnotation node, Void data) {
            return new Attribute((Node)node, "SimpleName", node.getSimpleName());
        }

        @Override
        public Attribute visit(ASTClassOrInterfaceType node, Void data) {
            return new Attribute((Node)node, "SimpleName", node.getSimpleName());
        }

        @Override
        public Attribute visit(ASTPrimitiveType node, Void data) {
            return new Attribute((Node)node, "Kind", node.getKind().getSimpleName());
        }

        @Override
        public Attribute visit(ASTMethodCall node, Void data) {
            return new Attribute((Node)node, "MethodName", node.getMethodName());
        }

        @Override
        public Attribute visit(ASTMethodReference node, Void data) {
            return new Attribute((Node)node, "MethodName", node.getMethodName());
        }

        @Override
        public Attribute visit(ASTFieldAccess node, Void data) {
            return new Attribute((Node)node, "Name", node.getName());
        }

        @Override
        public Attribute visit(ASTVariableAccess node, Void data) {
            return new Attribute((Node)node, "Name", node.getName());
        }

        @Override
        public Attribute visit(ASTMethodDeclaration node, Void data) {
            return new Attribute((Node)node, "Name", node.getName());
        }

        @Override
        public Attribute visit(ASTVariableDeclaratorId node, Void data) {
            return new Attribute((Node)node, "Name", node.getName());
        }

        @Override
        public Attribute visit(ASTAssignmentExpression node, Void data) {
            return new Attribute((Node)node, "Operator", node.getOperator().getToken());
        }

        @Override
        public Attribute visit(ASTUnaryExpression node, Void data) {
            return new Attribute((Node)node, "Operator", node.getOperator().getToken());
        }
    }
}

