/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;

@Deprecated
public class VariableNamingConventionsRule
extends AbstractJavaRule {
    private boolean checkMembers;
    private boolean checkLocals;
    private boolean checkParameters;
    private boolean checkNativeMethodParameters;
    private List<String> staticPrefixes;
    private List<String> staticSuffixes;
    private List<String> memberPrefixes;
    private List<String> memberSuffixes;
    private List<String> localPrefixes;
    private List<String> localSuffixes;
    private List<String> parameterPrefixes;
    private List<String> parameterSuffixes;
    private static final BooleanProperty CHECK_MEMBERS_DESCRIPTOR = new BooleanProperty("checkMembers", "Check member variables", true, 1.0f);
    private static final BooleanProperty CHECK_LOCALS_DESCRIPTOR = new BooleanProperty("checkLocals", "Check local variables", true, 2.0f);
    private static final BooleanProperty CHECK_PARAMETERS_DESCRIPTOR = new BooleanProperty("checkParameters", "Check constructor and method parameter variables", true, 3.0f);
    private static final BooleanProperty CHECK_NATIVE_METHOD_PARAMETERS_DESCRIPTOR = new BooleanProperty("checkNativeMethodParameters", "Check method parameter of native methods", true, 3.5f);
    private static final StringMultiProperty STATIC_PREFIXES_DESCRIPTOR = new StringMultiProperty("staticPrefix", "Static variable prefixes", new String[]{""}, 4.0f, ',');
    private static final StringMultiProperty STATIC_SUFFIXES_DESCRIPTOR = new StringMultiProperty("staticSuffix", "Static variable suffixes", new String[]{""}, 5.0f, ',');
    private static final StringMultiProperty MEMBER_PREFIXES_DESCRIPTOR = new StringMultiProperty("memberPrefix", "Member variable prefixes", new String[]{""}, 6.0f, ',');
    private static final StringMultiProperty MEMBER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("memberSuffix", "Member variable suffixes", new String[]{""}, 7.0f, ',');
    private static final StringMultiProperty LOCAL_PREFIXES_DESCRIPTOR = new StringMultiProperty("localPrefix", "Local variable prefixes", new String[]{""}, 8.0f, ',');
    private static final StringMultiProperty LOCAL_SUFFIXES_DESCRIPTOR = new StringMultiProperty("localSuffix", "Local variable suffixes", new String[]{""}, 9.0f, ',');
    private static final StringMultiProperty PARAMETER_PREFIXES_DESCRIPTOR = new StringMultiProperty("parameterPrefix", "Method parameter variable prefixes", new String[]{""}, 10.0f, ',');
    private static final StringMultiProperty PARAMETER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("parameterSuffix", "Method parameter variable suffixes", new String[]{""}, 11.0f, ',');

    public VariableNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHOD_PARAMETERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.checkMembers = (Boolean)this.getProperty((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.checkLocals = (Boolean)this.getProperty((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.checkParameters = (Boolean)this.getProperty((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.checkNativeMethodParameters = (Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHOD_PARAMETERS_DESCRIPTOR);
        this.staticPrefixes = (List)this.getProperty((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.staticSuffixes = (List)this.getProperty((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.memberPrefixes = (List)this.getProperty((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.memberSuffixes = (List)this.getProperty((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.localPrefixes = (List)this.getProperty((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.localSuffixes = (List)this.getProperty((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.parameterPrefixes = (List)this.getProperty((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.parameterSuffixes = (List)this.getProperty((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!this.checkMembers) {
            return data;
        }
        boolean isStatic = node.isStatic();
        boolean isFinal = node.isFinal();
        Node type = node.jjtGetParent().jjtGetParent().jjtGetParent();
        if (type instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)type).isInterface() || type instanceof ASTAnnotationTypeDeclaration) {
            isStatic = true;
            isFinal = true;
        }
        return this.checkVariableDeclarators(node.isStatic() ? this.staticPrefixes : this.memberPrefixes, isStatic ? this.staticSuffixes : this.memberSuffixes, node, isStatic, isFinal, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        if (!this.checkLocals) {
            return data;
        }
        return this.checkVariableDeclarators(this.localPrefixes, this.localSuffixes, node, false, node.isFinal(), data);
    }

    @Override
    public Object visit(ASTFormalParameters node, Object data) {
        if (!this.checkParameters) {
            return data;
        }
        ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class);
        if (!this.checkNativeMethodParameters && methodDeclaration.isNative()) {
            return data;
        }
        for (ASTFormalParameter formalParameter : node.findChildrenOfType(ASTFormalParameter.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : formalParameter.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                this.checkVariableDeclaratorId(this.parameterPrefixes, this.parameterSuffixes, false, formalParameter.isFinal(), variableDeclaratorId, data);
            }
        }
        return data;
    }

    private Object checkVariableDeclarators(List<String> prefixes, List<String> suffixes, Node root, boolean isStatic, boolean isFinal, Object data) {
        for (ASTVariableDeclarator variableDeclarator : root.findChildrenOfType(ASTVariableDeclarator.class)) {
            for (ASTVariableDeclaratorId variableDeclaratorId : variableDeclarator.findChildrenOfType(ASTVariableDeclaratorId.class)) {
                this.checkVariableDeclaratorId(prefixes, suffixes, isStatic, isFinal, variableDeclaratorId, data);
            }
        }
        return data;
    }

    private Object checkVariableDeclaratorId(List<String> prefixes, List<String> suffixes, boolean isStatic, boolean isFinal, ASTVariableDeclaratorId variableDeclaratorId, Object data) {
        String varName = variableDeclaratorId.getImage();
        if ("serialVersionUID".equals(varName)) {
            return data;
        }
        if (isStatic && isFinal) {
            if (!varName.equals(varName.toUpperCase(Locale.ROOT))) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Variables that are final and static should be all capitals, ''{0}'' is not all capitals.", new Object[]{varName});
            }
            return data;
        }
        if (!isFinal) {
            String normalizedVarName = this.normalizeVariableName(varName, prefixes, suffixes);
            if (normalizedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Only variables that are final should contain underscores (except for underscores in standard prefix/suffix), ''{0}'' is not final.", new Object[]{varName});
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, variableDeclaratorId, "Variables should start with a lowercase character, ''{0}'' starts with uppercase character.", new Object[]{varName});
            }
        }
        return data;
    }

    private String normalizeVariableName(String varName, List<String> prefixes, List<String> suffixes) {
        return this.stripSuffix(this.stripPrefix(varName, prefixes), suffixes);
    }

    private String stripSuffix(String varName, List<String> suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!varName.endsWith(suffix)) continue;
                varName = varName.substring(0, varName.length() - suffix.length());
                break;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, List<String> prefixes) {
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!varName.startsWith(prefix)) continue;
                return varName.substring(prefix.length());
            }
        }
        return varName;
    }

    public boolean hasPrefixesOrSuffixes() {
        for (PropertyDescriptor desc : this.getPropertyDescriptors()) {
            List values;
            if (!(desc instanceof StringMultiProperty) || (values = (List)this.getProperty((PropertyDescriptor)((StringMultiProperty)desc))).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String dysfunctionReason() {
        return this.hasPrefixesOrSuffixes() ? null : "No prefixes or suffixes specified";
    }
}

