/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;

public final class LocalVariableNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableDeclaratorId> {
    private final RegexProperty localVarRegex = this.defaultProp("localVar", "non-final local variable").build();
    private final RegexProperty finalVarRegex = this.defaultProp("finalVar", "final local variable").build();
    private final RegexProperty exceptionBlockParameterRegex = this.defaultProp("catchParameter", "exception block parameter").build();

    public LocalVariableNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)this.localVarRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.finalVarRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.exceptionBlockParameterRegex);
        this.addRuleChainVisit(ASTVariableDeclaratorId.class);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node.isExceptionBlockParameter()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.exceptionBlockParameterRegex, data);
        } else if (node.isLocalVariable()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)(node.isFinal() ? this.finalVarRegex : this.localVarRegex), data);
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String kindDisplayName(ASTVariableDeclaratorId node, PropertyDescriptor<Pattern> descriptor) {
        if (node.isExceptionBlockParameter()) {
            return "exception block parameter";
        }
        if (node.isLocalVariable()) {
            return node.isFinal() ? "final local variable" : "local variable";
        }
        throw new UnsupportedOperationException("This rule doesn't handle this case");
    }
}

