/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class FieldDeclarationsShouldBeAtStartOfClassRule
extends AbstractJavaRule {
    private BooleanProperty ignoreEnumDeclarations = new BooleanProperty("ignoreEnumDeclarations", "Ignore Enum Declarations that precede fields.", true, 1.0f);
    private BooleanProperty ignoreAnonymousClassDeclarations = new BooleanProperty("ignoreAnonymousClassDeclarations", "Ignore Field Declarations, that are initialized with anonymous class declarations", true, 2.0f);
    private BooleanProperty ignoreInterfaceDeclarations = new BooleanProperty("ignoreInterfaceDeclarations", "Ignore Interface Declarations that precede fields.", false, 3.0f);

    public FieldDeclarationsShouldBeAtStartOfClassRule() {
        this.definePropertyDescriptor((PropertyDescriptor)this.ignoreEnumDeclarations);
        this.definePropertyDescriptor((PropertyDescriptor)this.ignoreAnonymousClassDeclarations);
        this.definePropertyDescriptor((PropertyDescriptor)this.ignoreInterfaceDeclarations);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        Node parent = node.jjtGetParent().jjtGetParent();
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            Node child = parent.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                child = this.skipAnnotations(child);
            }
            if (child.equals(node)) break;
            if (child instanceof ASTFieldDeclaration || node.hasDescendantOfType(ASTClassOrInterfaceBodyDeclaration.class) && ((Boolean)this.getProperty((PropertyDescriptor)this.ignoreAnonymousClassDeclarations)).booleanValue()) continue;
            if (child instanceof ASTMethodDeclaration || child instanceof ASTConstructorDeclaration || child instanceof ASTAnnotationTypeDeclaration) {
                this.addViolation(data, node);
                break;
            }
            if (child instanceof ASTClassOrInterfaceDeclaration) {
                ASTClassOrInterfaceDeclaration declaration = (ASTClassOrInterfaceDeclaration)child;
                if (declaration.isInterface() && ((Boolean)this.getProperty((PropertyDescriptor)this.ignoreInterfaceDeclarations)).booleanValue()) continue;
                this.addViolation(data, node);
                break;
            }
            if (!(child instanceof ASTEnumDeclaration) || ((Boolean)this.getProperty((PropertyDescriptor)this.ignoreEnumDeclarations)).booleanValue()) continue;
            this.addViolation(data, node);
            break;
        }
        return data;
    }

    private Node skipAnnotations(Node child) {
        Node nextChild = child.jjtGetChild(0);
        for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
            if (child.jjtGetChild(j) instanceof ASTAnnotation) continue;
            nextChild = child.jjtGetChild(j);
            break;
        }
        return nextChild;
    }
}

