/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;

public class GuardLogStatementRule
extends AbstractJavaRule
implements Rule {
    private static final StringMultiProperty LOG_LEVELS = new StringMultiProperty("logLevels", "LogLevels to guard", new String[]{"trace", "debug", "info", "warn", "error", "log", "finest", "finer", "fine", "info", "warning", "severe"}, 1.0f, ',');
    private static final StringMultiProperty GUARD_METHODS = new StringMultiProperty("guardsMethods", "method use to guard the log statement", new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLoggable"}, 2.0f, ',');
    private Map<String, String> guardStmtByLogLevel = new HashMap<String, String>(12);
    private static final String JAVA_UTIL_LOG_METHOD = "log";
    private static final String JAVA_UTIL_LOG_GUARD_METHOD = "isLoggable";

    public GuardLogStatementRule() {
        this.definePropertyDescriptor((PropertyDescriptor)LOG_LEVELS);
        this.definePropertyDescriptor((PropertyDescriptor)GUARD_METHODS);
    }

    @Override
    public Object visit(ASTCompilationUnit unit, Object data) {
        this.extractProperties();
        return super.visit(unit, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTStatementExpression node, Object data) {
        if (node.jjtGetNumChildren() < 1 || !(node.jjtGetChild(0) instanceof ASTPrimaryExpression)) {
            return node;
        }
        ASTPrimaryExpression primary = (ASTPrimaryExpression)node.jjtGetChild(0);
        if (primary.jjtGetNumChildren() >= 2 && primary.jjtGetChild(0) instanceof ASTPrimaryPrefix) {
            ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)primary.jjtGetChild(0);
            String methodCall = this.getMethodCallName(prefix);
            String logLevel = this.getLogLevelName(primary, methodCall);
            if (this.guardStmtByLogLevel.containsKey(methodCall) && logLevel != null && primary.jjtGetChild(1) instanceof ASTPrimarySuffix && primary.jjtGetChild(1).hasDescendantOfType(ASTAdditiveExpression.class) && !this.hasGuard(primary, methodCall, logLevel)) {
                super.addViolation(data, (Node)node);
            }
        }
        return super.visit(node, data);
    }

    private boolean hasGuard(ASTPrimaryExpression node, String methodCall, String logLevel) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.getFirstParentOfType(ASTIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        ASTExpression expr = (ASTExpression)ifStatement.getFirstChildOfType(ASTExpression.class);
        List guardCalls = expr.findDescendantsOfType(ASTPrimaryPrefix.class);
        if (guardCalls.isEmpty()) {
            return false;
        }
        boolean foundGuard = false;
        for (ASTPrimaryPrefix guardCall : guardCalls) {
            if (guardCall.jjtGetNumChildren() < 1 || guardCall.jjtGetChild(0).getImage() == null) continue;
            String guardMethodCall = this.getLastPartOfName(guardCall.jjtGetChild(0));
            boolean guardMethodCallMatches = this.guardStmtByLogLevel.get(methodCall).contains(guardMethodCall);
            boolean hasArguments = guardCall.jjtGetParent().hasDescendantOfType(ASTArgumentList.class);
            if (guardMethodCallMatches && !JAVA_UTIL_LOG_GUARD_METHOD.equals(guardMethodCall)) {
                foundGuard = true;
            } else if (guardMethodCallMatches && hasArguments) {
                String guardArgLogLevel = this.getLogLevelName(guardCall.jjtGetParent(), guardMethodCall);
                foundGuard = logLevel.equals(guardArgLogLevel);
            }
            if (!foundGuard) continue;
            break;
        }
        return foundGuard;
    }

    private String getMethodCallName(ASTPrimaryPrefix prefix) {
        String result = "";
        if (prefix.jjtGetNumChildren() == 1 && prefix.jjtGetChild(0) instanceof ASTName) {
            result = this.getLastPartOfName(prefix.jjtGetChild(0));
        }
        return result;
    }

    private String getLastPartOfName(Node name) {
        int dotIndex;
        String result = "";
        if (name != null) {
            result = name.getImage();
        }
        if ((dotIndex = result.lastIndexOf(46)) > -1 && result.length() > dotIndex + 1) {
            result = result.substring(dotIndex + 1);
        }
        return result;
    }

    @SafeVarargs
    private static <N extends Node> N getFirstChild(Node root, Class<? extends Node> ... childrenTypes) {
        Node current = root;
        for (Class<? extends Node> clazz : childrenTypes) {
            Node child = (Node)current.getFirstChildOfType(clazz);
            if (child == null) {
                return null;
            }
            current = child;
        }
        Node result = current;
        return (N)result;
    }

    private String getLogLevelName(Node node, String methodCallName) {
        ASTArgumentList argumentList;
        if (!JAVA_UTIL_LOG_METHOD.equals(methodCallName) && !JAVA_UTIL_LOG_GUARD_METHOD.equals(methodCallName)) {
            return methodCallName;
        }
        String logLevel = null;
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)node.getFirstDescendantOfType(ASTPrimarySuffix.class);
        if (suffix != null && (argumentList = (ASTArgumentList)suffix.getFirstDescendantOfType(ASTArgumentList.class)) != null && argumentList.jjtGetNumChildren() > 0) {
            ASTName name = (ASTName)GuardLogStatementRule.getFirstChild(argumentList.jjtGetChild(0), ASTPrimaryExpression.class, ASTPrimaryPrefix.class, ASTName.class);
            String lastPart = this.getLastPartOfName(name);
            if (!(lastPart = lastPart.toLowerCase(Locale.ROOT)).isEmpty()) {
                logLevel = lastPart;
            }
        }
        return logLevel;
    }

    private void extractProperties() {
        if (this.guardStmtByLogLevel.isEmpty()) {
            ArrayList<String> logLevels = new ArrayList<String>((Collection)super.getProperty((PropertyDescriptor)LOG_LEVELS));
            ArrayList<String> guardMethods = new ArrayList<String>((Collection)super.getProperty((PropertyDescriptor)GUARD_METHODS));
            if (guardMethods.isEmpty() && !logLevels.isEmpty()) {
                throw new IllegalArgumentException("Can't specify logLevels without specifying guardMethods.");
            }
            if (logLevels.size() > guardMethods.size()) {
                int needed = logLevels.size() - guardMethods.size();
                String lastGuard = (String)guardMethods.get(guardMethods.size() - 1);
                for (int i = 0; i < needed; ++i) {
                    guardMethods.add(lastGuard);
                }
            }
            if (logLevels.size() != guardMethods.size()) {
                throw new IllegalArgumentException("For each logLevel a guardMethod must be specified.");
            }
            this.buildGuardStatementMap(logLevels, guardMethods);
        }
    }

    private void buildGuardStatementMap(List<String> logLevels, List<String> guardMethods) {
        for (int i = 0; i < logLevels.size(); ++i) {
            String logLevel = logLevels.get(i);
            if (this.guardStmtByLogLevel.containsKey(logLevel)) {
                String combinedGuard = this.guardStmtByLogLevel.get(logLevel);
                combinedGuard = combinedGuard + "|" + guardMethods.get(i);
                this.guardStmtByLogLevel.put(logLevel, combinedGuard);
                continue;
            }
            this.guardStmtByLogLevel.put(logLevel, guardMethods.get(i));
        }
    }
}

