/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class SuspiciousOctalEscapeRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTLiteral node, Object data) {
        if (node.isStringLiteral()) {
            String image = node.getImage();
            String s = image.substring(1, image.length() - 1);
            int offset = 0;
            int slash = s.indexOf(92, offset);
            while (slash != -1 && slash < s.length() - 1) {
                String escapeSequence = s.substring(slash + 1);
                char first = escapeSequence.charAt(0);
                offset = slash + 1;
                if (this.isOctal(first)) {
                    if (escapeSequence.length() > 1) {
                        char second = escapeSequence.charAt(1);
                        if (this.isOctal(second)) {
                            if (escapeSequence.length() > 2) {
                                char third = escapeSequence.charAt(2);
                                if (this.isOctal(third)) {
                                    char fourth;
                                    if (first != '0' && first != '1' && first != '2' && first != '3') {
                                        this.addViolation(data, node);
                                    } else if (escapeSequence.length() > 3 && this.isDecimal(fourth = escapeSequence.charAt(3))) {
                                        this.addViolation(data, node);
                                    }
                                } else if (this.isDecimal(third)) {
                                    this.addViolation(data, node);
                                }
                            }
                        } else if (this.isDecimal(second)) {
                            this.addViolation(data, node);
                        }
                    }
                } else if (first == '\\') {
                    ++offset;
                }
                slash = s.indexOf(92, offset);
            }
        }
        return super.visit(node, data);
    }

    private boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private boolean isDecimal(char c) {
        return c >= '0' && c <= '9';
    }
}

