/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;

public class ImportWrapper {
    private static final Logger LOG = Logger.getLogger(ImportWrapper.class.getName());
    private final ASTImportDeclaration node;
    private final String name;
    private final String fullname;
    private final boolean isStaticDemand;
    private final Set<String> allStaticDemands;

    public ImportWrapper(String fullname, String name) {
        this(fullname, name, null);
    }

    public ImportWrapper(String fullname, String name, ASTImportDeclaration node) {
        this(fullname, name, node, false);
    }

    public ImportWrapper(String fullname, String name, ASTImportDeclaration node, boolean isStaticDemand) {
        this.fullname = fullname;
        this.name = name;
        this.node = node;
        this.isStaticDemand = isStaticDemand;
        this.allStaticDemands = this.collectStaticFieldsAndMethods(node);
    }

    private Set<String> collectStaticFieldsAndMethods(ASTImportDeclaration node) {
        if (!this.isStaticDemand || node == null || node.getType() == null) {
            return Collections.emptySet();
        }
        try {
            HashSet<String> names = new HashSet<String>();
            Class<?> type = node.getType();
            for (Field field : type.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                names.add(field.getName());
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                names.add(((Method)accessibleObject).getName());
            }
            return names;
        }
        catch (LinkageError e) {
            LOG.log(Level.FINE, "Possible incomplete auxclasspath: Error while processing imports", e);
            return Collections.emptySet();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != ImportWrapper.class) {
            return false;
        }
        ImportWrapper i = (ImportWrapper)other;
        if (this.isStaticDemand != i.isStaticDemand) {
            return false;
        }
        if (this.name == null) {
            return this.fullname.equals(i.getFullName());
        }
        return this.name.equals(i.getName());
    }

    public boolean matches(ImportWrapper i) {
        if (this.isStaticDemand && this.allStaticDemands.contains(i.fullname)) {
            return true;
        }
        if (this.name == null && i.getName() == null) {
            return i.getFullName().equals(this.fullname);
        }
        return i.getName().equals(this.name);
    }

    public int hashCode() {
        if (this.name == null) {
            return Objects.hash(this.fullname, this.isStaticDemand);
        }
        return Objects.hash(this.name, this.isStaticDemand);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullname;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isStaticOnDemand() {
        return this.isStaticDemand;
    }

    public String toString() {
        return "Import[name=" + this.name + ",fullname=" + this.fullname + ",static*=" + this.isStaticDemand + ']';
    }
}

