/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.apache.commons.lang3.StringUtils;

public class InvalidLogMessageFormatRule
extends AbstractJavaRule {
    private static final Map<String, Set<String>> LOGGERS;

    public InvalidLogMessageFormatRule() {
        this.addRuleChainVisit(ASTName.class);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        NameDeclaration nameDeclaration = node.getNameDeclaration();
        if (!(nameDeclaration instanceof VariableNameDeclaration)) {
            return data;
        }
        Class<?> type = ((VariableNameDeclaration)nameDeclaration).getType();
        if (type == null || !LOGGERS.containsKey(type.getName())) {
            return data;
        }
        String loggingClass = type.getName();
        ASTPrimaryExpression parentNode = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class);
        String method = ((ASTName)((ASTPrimaryPrefix)parentNode.getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class)).getImage().replace(nameDeclaration.getImage() + ".", "");
        if (!LOGGERS.get(loggingClass).contains(method)) {
            return data;
        }
        List argumentList = ((ASTArgumentList)((ASTPrimarySuffix)parentNode.getFirstChildOfType(ASTPrimarySuffix.class)).getFirstDescendantOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class);
        ASTExpression messageParam = (ASTExpression)argumentList.remove(0);
        int expectedArguments = this.expectedArguments(messageParam);
        if (expectedArguments == -1) {
            return data;
        }
        if (argumentList.size() > expectedArguments) {
            this.removeThrowableParam(argumentList);
        }
        if (argumentList.size() < expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Missing arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        } else if (argumentList.size() > expectedArguments) {
            this.addViolationWithMessage(data, (Node)node, "Too many arguments," + this.getExpectedMessage(argumentList, expectedArguments));
        }
        return data;
    }

    private boolean isNewThrowable(ASTPrimaryExpression last) {
        ASTClassOrInterfaceType classOrInterface = (ASTClassOrInterfaceType)last.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        return classOrInterface != null && classOrInterface.getType() != null && TypeHelper.isA((TypeNode)classOrInterface, Throwable.class);
    }

    private boolean hasTypeThrowable(ASTPrimaryExpression last) {
        return last.getType() != null && TypeHelper.isA((TypeNode)last, Throwable.class);
    }

    private boolean isReferencingThrowable(ASTPrimaryExpression last) {
        ASTName variable = (ASTName)last.getFirstDescendantOfType(ASTName.class);
        if (variable != null && variable.getNameDeclaration() != null && variable.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration declaration = (VariableNameDeclaration)variable.getNameDeclaration();
            if (declaration.getType() != null && Throwable.class.isAssignableFrom(declaration.getType())) {
                return true;
            }
            if (declaration.getTypeImage() != null && declaration.getTypeImage().endsWith("Exception")) {
                return true;
            }
        }
        return false;
    }

    private void removeThrowableParam(List<ASTExpression> params) {
        if (params.isEmpty()) {
            return;
        }
        int lastIndex = params.size() - 1;
        ASTPrimaryExpression last = (ASTPrimaryExpression)params.get(lastIndex).getFirstDescendantOfType(ASTPrimaryExpression.class);
        if (this.isNewThrowable(last) || this.hasTypeThrowable(last) || this.isReferencingThrowable(last)) {
            params.remove(lastIndex);
        }
    }

    private String getExpectedMessage(List<ASTExpression> params, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but have " + params.size();
    }

    private int expectedArguments(ASTExpression node) {
        int count = -1;
        if (node.getFirstDescendantOfType(ASTLiteral.class) != null) {
            count = this.countPlaceholders(node);
        } else if (node.getFirstDescendantOfType(ASTName.class) != null) {
            String variableName = ((ASTName)node.getFirstDescendantOfType(ASTName.class)).getImage();
            JavaNode parentBlock = (JavaNode)node.getFirstParentOfAnyType(new Class[]{ASTMethodOrConstructorDeclaration.class, ASTInitializer.class, ASTLambdaExpression.class});
            if (parentBlock != null) {
                List localVariables = parentBlock.findDescendantsOfType(ASTVariableDeclarator.class);
                count = this.getAmountOfExpectedArguments(variableName, localVariables);
            }
            if (count == -1) {
                List fieldlist = ((AbstractJavaNode)node.getFirstParentOfAnyType(new Class[]{ASTClassOrInterfaceBody.class, ASTEnumBody.class})).findDescendantsOfType(ASTFieldDeclaration.class);
                ArrayList<ASTVariableDeclarator> fields = new ArrayList<ASTVariableDeclarator>(fieldlist.size());
                for (ASTFieldDeclaration astFieldDeclaration : fieldlist) {
                    fields.add((ASTVariableDeclarator)astFieldDeclaration.getFirstChildOfType(ASTVariableDeclarator.class));
                }
                count = this.getAmountOfExpectedArguments(variableName, fields);
            }
        }
        return count;
    }

    private int getAmountOfExpectedArguments(String variableName, List<ASTVariableDeclarator> variables) {
        for (ASTVariableDeclarator astVariableDeclarator : variables) {
            if (!((ASTVariableDeclaratorId)astVariableDeclarator.getFirstChildOfType(ASTVariableDeclaratorId.class)).getImage().equals(variableName)) continue;
            ASTVariableInitializer variableInitializer = (ASTVariableInitializer)astVariableDeclarator.getFirstDescendantOfType(ASTVariableInitializer.class);
            ASTExpression expression = null;
            if (variableInitializer != null) {
                expression = (ASTExpression)variableInitializer.getFirstChildOfType(ASTExpression.class);
            }
            if (expression == null) continue;
            return this.countPlaceholders(expression);
        }
        return -1;
    }

    private int countPlaceholders(ASTExpression node) {
        List<ASTLiteral> literals = this.getStringLiterals((Node)node);
        if (literals.isEmpty()) {
            return -1;
        }
        int result = 0;
        for (ASTLiteral stringLiteral : literals) {
            result += StringUtils.countMatches((CharSequence)stringLiteral.getImage(), (CharSequence)"{}");
        }
        return result;
    }

    private List<ASTLiteral> getStringLiterals(Node node) {
        ArrayList<ASTLiteral> stringLiterals = new ArrayList<ASTLiteral>();
        for (ASTLiteral literal : node.findDescendantsOfType(ASTLiteral.class)) {
            if (!literal.isStringLiteral()) continue;
            stringLiterals.add(literal);
        }
        return stringLiterals;
    }

    static {
        HashMap<String, Set<String>> loggersMap = new HashMap<String, Set<String>>();
        loggersMap.put("org.slf4j.Logger", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error"))));
        loggersMap.put("org.apache.logging.log4j.Logger", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error", "fatal", "all"))));
        LOGGERS = loggersMap;
    }
}

