/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DFAGraphMethod;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSignature;

public class ASTMethodDeclaration
extends AbstractJavaAccessNode
implements DFAGraphMethod,
ASTMethodOrConstructorDeclaration {
    private JavaQualifiedName qualifiedName;
    private JavaOperationSignature signature;

    public ASTMethodDeclaration(int id) {
        super(id);
    }

    public ASTMethodDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getMethodName() {
        ASTMethodDeclarator md = (ASTMethodDeclarator)this.getFirstChildOfType(ASTMethodDeclarator.class);
        if (md != null) {
            return md.getImage();
        }
        return null;
    }

    public String getName() {
        return this.getMethodName();
    }

    public boolean isSyntacticallyPublic() {
        return super.isPublic();
    }

    public boolean isSyntacticallyAbstract() {
        return super.isAbstract();
    }

    @Override
    public boolean isPublic() {
        if (this.isInterfaceMember() && !this.isPrivate()) {
            return true;
        }
        return super.isPublic();
    }

    @Override
    public boolean isAbstract() {
        if (this.isInterfaceMember()) {
            return true;
        }
        return super.isAbstract();
    }

    public boolean isInterfaceMember() {
        Node potentialTypeDeclaration = this.getNthParent(3);
        if (potentialTypeDeclaration instanceof ASTClassOrInterfaceDeclaration) {
            return ((ASTClassOrInterfaceDeclaration)potentialTypeDeclaration).isInterface();
        }
        return false;
    }

    public boolean isVoid() {
        return this.getResultType().isVoid();
    }

    public ASTResultType getResultType() {
        return (ASTResultType)this.getFirstChildOfType(ASTResultType.class);
    }

    public ASTBlock getBlock() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            Node n = this.jjtGetChild(i);
            if (!(n instanceof ASTBlock)) continue;
            return (ASTBlock)n;
        }
        return null;
    }

    public ASTNameList getThrows() {
        Node n;
        int declaratorIndex = -1;
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            Node child = this.jjtGetChild(i);
            if (!(child instanceof ASTMethodDeclarator)) continue;
            declaratorIndex = i;
            break;
        }
        if (this.jjtGetNumChildren() > declaratorIndex + 1 && (n = this.jjtGetChild(declaratorIndex + 1)) instanceof ASTNameList) {
            return (ASTNameList)n;
        }
        return null;
    }

    @Override
    public JavaQualifiedName getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = JavaQualifiedName.ofOperation(this);
        }
        return this.qualifiedName;
    }

    @Override
    public JavaOperationSignature getSignature() {
        if (this.signature == null) {
            this.signature = JavaOperationSignature.buildFor(this);
        }
        return this.signature;
    }
}

