/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;
import org.jaxen.JaxenException;

public class GuardLogStatementRule
extends AbstractJavaRule
implements Rule {
    private static final StringMultiProperty LOG_LEVELS = new StringMultiProperty("logLevels", "LogLevels to guard", new String[]{"trace", "debug", "info", "warn", "error", "log", "finest", "finer", "fine", "info", "warning", "severe"}, 1.0f, ',');
    private static final StringMultiProperty GUARD_METHODS = new StringMultiProperty("guardsMethods", "method use to guard the log statement", new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLoggable"}, 2.0f, ',');
    private Map<String, String> guardStmtByLogLevel = new HashMap<String, String>(12);
    private static final String XPATH_EXPRESSION = "//StatementExpression/PrimaryExpression/PrimaryPrefix[ends-with(Name/@Image, 'LOG_LEVEL')]\n[..//AdditiveExpression]\n[not(ancestor::IfStatement) or\n not(ancestor::IfStatement/Expression/PrimaryExpression/PrimaryPrefix/Name[contains('GUARD', substring-after(@Image, '.'))])]\n|\n//StatementExpression/PrimaryExpression/PrimaryPrefix[ends-with(Name/@Image, 'LOG_LEVEL_UPPERCASE')]\n[../../..//AdditiveExpression]\n[not(ancestor::IfStatement) or\n not(ancestor::IfStatement/Expression/PrimaryExpression\n    [contains('GUARD', substring-after(PrimaryPrefix/Name/@Image, '.'))]\n    [ends-with(PrimarySuffix//Name/@Image, 'LOG_LEVEL_UPPERCASE')])\n]";

    public GuardLogStatementRule() {
        this.definePropertyDescriptor((PropertyDescriptor)LOG_LEVELS);
        this.definePropertyDescriptor((PropertyDescriptor)GUARD_METHODS);
    }

    @Override
    public Object visit(ASTCompilationUnit unit, Object data) {
        this.extractProperties();
        this.findViolationForEachLogStatement(unit, data, XPATH_EXPRESSION);
        return super.visit(unit, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    private void findViolationForEachLogStatement(ASTCompilationUnit unit, Object data, String xpathExpression) {
        for (Map.Entry<String, String> entry : this.guardStmtByLogLevel.entrySet()) {
            List<Node> nodes = this.findViolations(unit, entry.getKey(), entry.getValue(), xpathExpression);
            for (Node node : nodes) {
                super.addViolation(data, node);
            }
        }
    }

    private List<Node> findViolations(ASTCompilationUnit unit, String logLevel, String guard, String xpathExpression) {
        try {
            String xpath = xpathExpression.replaceAll("LOG_LEVEL_UPPERCASE", logLevel.toUpperCase()).replaceAll("LOG_LEVEL", logLevel).replaceAll("GUARD", guard);
            return unit.findChildNodesWithXPath(xpath);
        }
        catch (JaxenException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    private void extractProperties() {
        if (this.guardStmtByLogLevel.isEmpty()) {
            ArrayList<String> logLevels = new ArrayList<String>((Collection)super.getProperty((PropertyDescriptor)LOG_LEVELS));
            ArrayList<String> guardMethods = new ArrayList<String>((Collection)super.getProperty((PropertyDescriptor)GUARD_METHODS));
            if (guardMethods.isEmpty() && !logLevels.isEmpty()) {
                throw new IllegalArgumentException("Can't specify logLevels without specifying guardMethods.");
            }
            if (logLevels.size() > guardMethods.size()) {
                int needed = logLevels.size() - guardMethods.size();
                String lastGuard = (String)guardMethods.get(guardMethods.size() - 1);
                for (int i = 0; i < needed; ++i) {
                    guardMethods.add(lastGuard);
                }
            }
            if (logLevels.size() != guardMethods.size()) {
                throw new IllegalArgumentException("For each logLevel a guardMethod must be specified.");
            }
            this.buildGuardStatementMap(logLevels, guardMethods);
        }
    }

    private void buildGuardStatementMap(List<String> logLevels, List<String> guardMethods) {
        for (int i = 0; i < logLevels.size(); ++i) {
            String logLevel = "." + logLevels.get(i);
            if (this.guardStmtByLogLevel.containsKey(logLevel)) {
                String combinedGuard = this.guardStmtByLogLevel.get(logLevel);
                combinedGuard = combinedGuard + "|" + guardMethods.get(i);
                this.guardStmtByLogLevel.put(logLevel, combinedGuard);
                continue;
            }
            this.guardStmtByLogLevel.put(logLevel, guardMethods.get(i));
        }
    }
}

