/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.visitors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class TccMethodPairVisitor
extends JavaParserVisitorReducedAdapter {
    Stack<Map<String, Set<String>>> methodAttributeAccess = new Stack();
    private String currentMethodName;

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        this.methodAttributeAccess.push(new HashMap());
        super.visit(node, data);
        this.methodAttributeAccess.peek().remove(null);
        return this.methodAttributeAccess.pop();
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!node.isAbstract()) {
            this.currentMethodName = node.getQualifiedName().getOperation();
            this.methodAttributeAccess.peek().put(this.currentMethodName, new HashSet());
            super.visit(node, data);
            this.currentMethodName = null;
        }
        return null;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (this.currentMethodName != null) {
            Set<String> methodAccess = this.methodAttributeAccess.peek().get(this.currentMethodName);
            String variableName = this.getVariableName(node);
            if (this.isLocalAttributeAccess(variableName, node.getScope())) {
                methodAccess.add(variableName);
            }
        }
        return super.visit(node, data);
    }

    private String getVariableName(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)node.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        ASTName name = (ASTName)prefix.getFirstDescendantOfType(ASTName.class);
        String variableName = null;
        if (name != null) {
            int dotIndex = name.getImage().indexOf(".");
            variableName = dotIndex == -1 ? name.getImage() : name.getImage().substring(0, dotIndex);
        }
        return variableName;
    }

    private boolean isLocalAttributeAccess(String varName, Scope scope) {
        for (Scope currentScope = scope; currentScope != null; currentScope = currentScope.getParent()) {
            for (VariableNameDeclaration decl : currentScope.getDeclarations(VariableNameDeclaration.class).keySet()) {
                if (!decl.getImage().equals(varName) || !(currentScope instanceof ClassScope)) continue;
                return true;
            }
        }
        return false;
    }
}

