/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.metrics.AbstractJavaMetric;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetric;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaFieldSigMask;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSigMask;

public abstract class AbstractJavaClassMetric
extends AbstractJavaMetric<ASTAnyTypeDeclaration>
implements JavaClassMetric {
    public boolean supports(ASTAnyTypeDeclaration node) {
        return node.getTypeKind() != ASTAnyTypeDeclaration.TypeKind.ANNOTATION && node.getTypeKind() != ASTAnyTypeDeclaration.TypeKind.INTERFACE;
    }

    protected int countMatchingOpSigs(ASTAnyTypeDeclaration classNode, JavaOperationSigMask mask) {
        int count = 0;
        List<ASTMethodOrConstructorDeclaration> decls = this.getMethodsAndConstructors(classNode);
        for (ASTMethodOrConstructorDeclaration decl : decls) {
            if (!mask.covers(decl.getSignature())) continue;
            ++count;
        }
        return count;
    }

    protected int countMatchingFieldSigs(ASTAnyTypeDeclaration classNode, JavaFieldSigMask mask) {
        int count = 0;
        List<ASTFieldDeclaration> decls = this.getFields(classNode);
        for (ASTFieldDeclaration decl : decls) {
            if (!mask.covers(decl.getSignature())) continue;
            ++count;
        }
        return count;
    }

    protected List<ASTMethodOrConstructorDeclaration> getMethodsAndConstructors(ASTAnyTypeDeclaration node) {
        return this.getDeclarationsOfType(node, ASTMethodOrConstructorDeclaration.class);
    }

    protected List<ASTFieldDeclaration> getFields(ASTAnyTypeDeclaration node) {
        return this.getDeclarationsOfType(node, ASTFieldDeclaration.class);
    }

    private <T extends Node> List<T> getDeclarationsOfType(ASTAnyTypeDeclaration node, Class<T> tClass) {
        ArrayList<T> result = new ArrayList<T>();
        List<ASTAnyTypeBodyDeclaration> decls = node.getDeclarations();
        for (ASTAnyTypeBodyDeclaration decl : decls) {
            if (!tClass.isInstance(decl.jjtGetChild(0))) continue;
            result.add(tClass.cast(decl.jjtGetChild(0)));
        }
        return result;
    }
}

