/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typedefinition;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinition;

public class JavaTypeDefinition
implements TypeDefinition {
    private static final Map<Class<?>, JavaTypeDefinition> CLASS_TYPE_DEF_CACHE = new HashMap();
    private final Class<?> clazz;
    private final List<JavaTypeDefinition> genericArgs;
    private final boolean isGeneric;

    private JavaTypeDefinition(Class<?> clazz) {
        this.clazz = clazz;
        TypeVariable<Class<?>>[] typeParameters = clazz.isAnonymousClass() ? (clazz.getSuperclass() == Object.class ? clazz.getInterfaces()[0].getTypeParameters() : clazz.getSuperclass().getTypeParameters()) : clazz.getTypeParameters();
        this.isGeneric = typeParameters.length != 0;
        this.genericArgs = this.isGeneric ? new ArrayList<JavaTypeDefinition>(typeParameters.length) : Collections.emptyList();
    }

    public static JavaTypeDefinition forClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        JavaTypeDefinition typeDef = CLASS_TYPE_DEF_CACHE.get(clazz);
        if (typeDef != null) {
            return typeDef;
        }
        JavaTypeDefinition newDef = new JavaTypeDefinition(clazz);
        if (!newDef.isGeneric) {
            CLASS_TYPE_DEF_CACHE.put(clazz, newDef);
        }
        return newDef;
    }

    public static JavaTypeDefinition forClass(Class<?> clazz, JavaTypeDefinition ... boundGenerics) {
        if (clazz == null) {
            return null;
        }
        JavaTypeDefinition typeDef = new JavaTypeDefinition(clazz);
        for (JavaTypeDefinition generic : boundGenerics) {
            typeDef.genericArgs.add(generic);
        }
        return typeDef;
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    public boolean isGeneric() {
        return !this.genericArgs.isEmpty();
    }

    public JavaTypeDefinition getGenericType(String parameterName) {
        TypeVariable<Class<?>>[] typeParameters = this.clazz.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameters[i].getName().equals(parameterName)) continue;
            return this.getGenericType(i);
        }
        throw new IllegalArgumentException("No generic parameter by name " + parameterName + " on class " + this.clazz.getSimpleName());
    }

    public JavaTypeDefinition getGenericType(int index) {
        JavaTypeDefinition cachedDefinition;
        if (this.genericArgs.size() > index && (cachedDefinition = this.genericArgs.get(index)) != null) {
            return cachedDefinition;
        }
        for (int i = this.genericArgs.size(); i <= index; ++i) {
            this.genericArgs.add(null);
        }
        this.genericArgs.set(index, JavaTypeDefinition.forClass(Object.class));
        TypeVariable<Class<?>> typeVariable = this.clazz.getTypeParameters()[index];
        JavaTypeDefinition typeDefinition = this.resolveTypeDefinition(typeVariable.getBounds()[0]);
        this.genericArgs.set(index, typeDefinition);
        return typeDefinition;
    }

    public JavaTypeDefinition resolveTypeDefinition(Type type) {
        if (type == null) {
            return JavaTypeDefinition.forClass(Object.class);
        }
        if (type instanceof Class) {
            return JavaTypeDefinition.forClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            JavaTypeDefinition[] genericBounds = new JavaTypeDefinition[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                genericBounds[i] = this.resolveTypeDefinition(typeArguments[i]);
            }
            return JavaTypeDefinition.forClass((Class)parameterizedType.getRawType(), genericBounds);
        }
        if (type instanceof TypeVariable) {
            return this.getGenericType(((TypeVariable)type).getName());
        }
        if (type instanceof WildcardType) {
            Type[] wildcardUpperBounds = ((WildcardType)type).getUpperBounds();
            if (wildcardUpperBounds.length != 0) {
                return this.resolveTypeDefinition(wildcardUpperBounds[0]);
            }
            return JavaTypeDefinition.forClass(Object.class);
        }
        return JavaTypeDefinition.forClass(Object.class);
    }
}

