/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.rule;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.oom.Metrics;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.Metric;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.ResultOption;
import net.sourceforge.pmd.lang.java.oom.metrics.CycloMetric;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class CyclomaticComplexityRule
extends AbstractJavaRule {
    public static final IntegerProperty REPORT_LEVEL_DESCRIPTOR = new IntegerProperty("reportLevel", "Cyclomatic Complexity reporting threshold", Integer.valueOf(1), Integer.valueOf(30), Integer.valueOf(10), 1.0f);
    public static final BooleanProperty SHOW_CLASSES_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showClassesComplexity", "Add class average violations to the report", Boolean.valueOf(true), 2.0f);
    public static final BooleanProperty SHOW_METHODS_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showMethodsComplexity", "Add method average violations to the report", Boolean.valueOf(true), 3.0f);
    private static final String[] VERSION_LABELS = new String[]{"standard", "ignoreBooleanPaths"};
    private static final MetricVersion[] CYCLO_VERSIONS = new MetricVersion[]{Metric.Version.STANDARD, CycloMetric.Version.IGNORE_BOOLEAN_PATHS};
    public static final EnumeratedProperty<MetricVersion> CYCLO_VERSION_DESCRIPTOR = new EnumeratedProperty("cycloVersion", "Choose a variant of Cyclo or the standard", VERSION_LABELS, (Object[])CYCLO_VERSIONS, 0, 3.0f);
    private int reportLevel;
    private boolean showClassesComplexity = true;
    private boolean showMethodsComplexity = true;
    private MetricVersion cycloVersion = Metric.Version.STANDARD;

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CYCLO_VERSION_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = (Integer)this.getProperty((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        this.showClassesComplexity = (Boolean)this.getProperty((PropertyDescriptor)SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.showMethodsComplexity = (Boolean)this.getProperty((PropertyDescriptor)SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
        Object version = this.getProperty((PropertyDescriptor)CYCLO_VERSION_DESCRIPTOR);
        this.cycloVersion = version instanceof MetricVersion ? (MetricVersion)version : Metric.Version.STANDARD;
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        super.visit(node, data);
        if (this.showClassesComplexity) {
            int classCyclo = (int)Metrics.get(ClassMetricKey.CYCLO, node, this.cycloVersion);
            int classHighest = (int)Metrics.get(OperationMetricKey.CYCLO, node, this.cycloVersion, ResultOption.HIGHEST);
            if (classCyclo >= this.reportLevel || classHighest >= this.reportLevel) {
                this.addViolation(data, node, new String[]{"class", node.getImage(), classCyclo + " (Highest = " + classHighest + ')'});
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        int cyclo = (int)Metrics.get(OperationMetricKey.CYCLO, node, this.cycloVersion);
        if (this.showMethodsComplexity && cyclo >= this.reportLevel) {
            this.addViolation(data, node, new String[]{"method", node.getQualifiedName().getOperation(), "" + cyclo});
        }
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        int cyclo = (int)Metrics.get(OperationMetricKey.CYCLO, node, this.cycloVersion);
        if (this.showMethodsComplexity && cyclo >= this.reportLevel) {
            this.addViolation(data, node, new String[]{"constructor", node.getQualifiedName().getOperation(), "" + cyclo});
        }
        return data;
    }
}

