/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.metrics.cyclo;

import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.oom.metrics.cyclo.CycloPathUnawareOperationVisitor;
import net.sourceforge.pmd.lang.java.rule.codesize.NPathComplexityRule;
import org.apache.commons.lang3.mutable.MutableInt;

public class StandardCycloVisitor
extends CycloPathUnawareOperationVisitor {
    @Override
    public Object visit(ASTIfStatement node, Object data) {
        super.visit(node, data);
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        ((MutableInt)data).add(boolCompIf);
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        super.visit(node, data);
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstDescendantOfType(ASTExpression.class));
        ((MutableInt)data).add(boolCompFor);
        return data;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        super.visit(node, data);
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        ((MutableInt)data).add(boolCompDo);
        return data;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        super.visit((JavaNode)node, data);
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        ((MutableInt)data).add(boolCompSwitch);
        return data;
    }

    @Override
    public Object visit(ASTSwitchLabel node, Object data) {
        if (!node.isDefault()) {
            ((MutableInt)data).increment();
        }
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        super.visit(node, data);
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        ((MutableInt)data).add(boolCompWhile);
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        super.visit(node, data);
        if (node.isTernary()) {
            int boolCompTern = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
            ((MutableInt)data).add(boolCompTern);
        }
        return data;
    }
}

