/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.metrics;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.QualifiedName;
import net.sourceforge.pmd.lang.java.oom.AbstractMetric;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetric;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetric;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSigMask;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSignature;
import net.sourceforge.pmd.lang.java.oom.signature.Signature;

public final class AtfdMetric
extends AbstractMetric
implements ClassMetric,
OperationMetric {
    @Override
    public boolean supports(AccessNode node) {
        return node instanceof ASTClassOrInterfaceDeclaration || node instanceof ASTMethodOrConstructorDeclaration && !node.isAbstract();
    }

    @Override
    public double computeFor(ASTMethodOrConstructorDeclaration node, MetricVersion version) {
        OperationSigMask targetOps = new OperationSigMask();
        targetOps.restrictVisibilitiesTo(Signature.Visibility.PUBLIC);
        targetOps.restrictRolesTo(OperationSignature.Role.GETTER_OR_SETTER);
        List<QualifiedName> callQNames = this.findAllCalls(node);
        int foreignCalls = 0;
        for (QualifiedName name : callQNames) {
            if (!AtfdMetric.getTopLevelPackageStats().hasMatchingSig(name, targetOps)) continue;
            ++foreignCalls;
        }
        return foreignCalls / callQNames.size();
    }

    @Override
    public double computeFor(ASTClassOrInterfaceDeclaration node, MetricVersion version) {
        return 0.0;
    }
}

