/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.oom.ParameterizedMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetric;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;

class OperationStats {
    private final String name;
    private final Map<ParameterizedMetricKey, Double> memo = new HashMap<ParameterizedMetricKey, Double>();

    OperationStats(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    double compute(OperationMetricKey key, ASTMethodOrConstructorDeclaration node, boolean force, MetricVersion version) {
        ParameterizedMetricKey paramKey = ParameterizedMetricKey.build(key, version);
        Double prev = this.memo.get(paramKey);
        if (!force && prev != null) {
            return prev;
        }
        OperationMetric metric = key.getCalculator();
        double val = metric.computeFor(node, version);
        this.memo.put(paramKey, val);
        return val;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationStats stats = (OperationStats)o;
        return this.name != null ? this.name.equals(stats.name) : stats.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

