/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.logging;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import org.apache.commons.lang3.StringUtils;

public class InvalidSlf4jMessageFormatRule
extends AbstractJavaRule {
    private static final Set<String> LOGGER_LEVELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error")));
    private static final String LOGGER_CLASS = "org.slf4j.Logger";

    @Override
    public Object visit(ASTName node, Object data) {
        NameDeclaration nameDeclaration = node.getNameDeclaration();
        if (nameDeclaration == null || !(nameDeclaration instanceof VariableNameDeclaration)) {
            return super.visit(node, data);
        }
        Class<?> type = ((VariableNameDeclaration)nameDeclaration).getType();
        if (type == null || !type.getName().equals(LOGGER_CLASS)) {
            return super.visit(node, data);
        }
        ASTPrimaryExpression parentNode = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class);
        String method = ((ASTName)((ASTPrimaryPrefix)parentNode.getFirstChildOfType(ASTPrimaryPrefix.class)).getFirstChildOfType(ASTName.class)).getImage().replace(nameDeclaration.getImage() + ".", "");
        if (!LOGGER_LEVELS.contains(method)) {
            return super.visit(node, data);
        }
        LinkedList<ASTPrimaryExpression> params = new LinkedList<ASTPrimaryExpression>();
        List argumentList = ((ASTArgumentList)((ASTPrimarySuffix)parentNode.getFirstChildOfType(ASTPrimarySuffix.class)).getFirstDescendantOfType(ASTArgumentList.class)).findChildrenOfType(ASTExpression.class);
        for (ASTExpression astExpression : argumentList) {
            params.add((ASTPrimaryExpression)astExpression.getFirstChildOfType(ASTPrimaryExpression.class));
        }
        ASTPrimaryExpression messageParam = (ASTPrimaryExpression)params.get(0);
        params.remove(0);
        int expectedArguments = this.expectedArguments(messageParam);
        if (expectedArguments == 0) {
            return super.visit(node, data);
        }
        this.removeThrowableParam(params);
        if (params.size() < expectedArguments) {
            this.addViolationWithMessage(data, node, "Missing arguments," + this.getExpectedMessage(params, expectedArguments));
        } else if (params.size() > expectedArguments) {
            this.addViolationWithMessage(data, node, "Too many arguments," + this.getExpectedMessage(params, expectedArguments));
        }
        return super.visit(node, data);
    }

    private void removeThrowableParam(List<ASTPrimaryExpression> params) {
        Iterator<ASTPrimaryExpression> it = params.iterator();
        while (it.hasNext()) {
            ASTClassOrInterfaceType throwable = (ASTClassOrInterfaceType)it.next().getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (throwable == null || !Throwable.class.isAssignableFrom(throwable.getType())) continue;
            it.remove();
        }
    }

    private String getExpectedMessage(List<ASTPrimaryExpression> params, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but have " + params.size();
    }

    private int expectedArguments(ASTPrimaryExpression node) {
        List localValiables;
        String variableName;
        int count = 0;
        if (node.getFirstDescendantOfType(ASTLiteral.class) != null) {
            count = this.countPlaceholders(node);
        } else if (node.getFirstDescendantOfType(ASTName.class) != null && (count = this.getAmountOfExpectedArguments(variableName = ((ASTName)node.getFirstDescendantOfType(ASTName.class)).getImage(), localValiables = ((ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class)).findDescendantsOfType(ASTVariableDeclarator.class))) == 0) {
            List fieldlist = ((ASTClassOrInterfaceBody)node.getFirstParentOfType(ASTClassOrInterfaceBody.class)).findDescendantsOfType(ASTFieldDeclaration.class);
            LinkedList<ASTVariableDeclarator> fields = new LinkedList<ASTVariableDeclarator>();
            for (ASTFieldDeclaration astFieldDeclaration : fieldlist) {
                fields.add((ASTVariableDeclarator)astFieldDeclaration.getFirstChildOfType(ASTVariableDeclarator.class));
            }
            count = this.getAmountOfExpectedArguments(variableName, fields);
        }
        return count;
    }

    private int getAmountOfExpectedArguments(String variableName, List<ASTVariableDeclarator> variables) {
        for (ASTVariableDeclarator astVariableDeclarator : variables) {
            if (!((ASTVariableDeclaratorId)astVariableDeclarator.getFirstChildOfType(ASTVariableDeclaratorId.class)).getImage().equals(variableName)) continue;
            return this.countPlaceholders(astVariableDeclarator);
        }
        return 0;
    }

    private int countPlaceholders(AbstractJavaTypeNode node) {
        return StringUtils.countMatches((CharSequence)((ASTLiteral)node.getFirstDescendantOfType(ASTLiteral.class)).getImage(), (CharSequence)"{}");
    }
}

