/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.unusedcode;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class UnusedModifierRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isNested()) {
            return super.visit(node, data);
        }
        ASTClassOrInterfaceDeclaration parentClassOrInterface = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        ASTEnumDeclaration parentEnum = (ASTEnumDeclaration)node.getFirstParentOfType(ASTEnumDeclaration.class);
        if (node.isInterface() && node.isPublic() && parentClassOrInterface != null && parentClassOrInterface.isInterface()) {
            this.addViolation(data, node, this.getMessage());
        }
        if (node.isInterface() && node.isStatic() && (parentClassOrInterface != null || parentEnum != null)) {
            this.addViolation(data, node, this.getMessage());
        }
        if (!node.isInterface() && (node.isPublic() || node.isStatic()) && parentClassOrInterface != null && parentClassOrInterface.isInterface()) {
            this.addViolation(data, node, this.getMessage());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isSyntacticallyPublic() || node.isSyntacticallyAbstract()) {
            this.check(node, data);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (node.isSyntacticallyPublic() || node.isSyntacticallyStatic() || node.isSyntacticallyFinal()) {
            this.check(node, data);
        }
        return super.visit(node, data);
    }

    private void check(Node fieldOrMethod, Object data) {
        Node parent = fieldOrMethod.jjtGetParent().jjtGetParent().jjtGetParent();
        if (parent instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            this.addViolation(data, fieldOrMethod);
        }
    }
}

