/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.modularity.locality;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SyntacticLocalityEvaluator
implements LocalityEvaluator {
    @Nonnull
    protected final LocalityClass localityCls;
    @Nonnull
    private final AxiomLocalityVisitor axiomVisitor = new AxiomLocalityVisitor();
    @Nonnull
    private static final EnumSet<LocalityClass> SUPPORTED_LOCALITY_CLASSES = EnumSet.of(LocalityClass.TOP_BOTTOM, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);

    public SyntacticLocalityEvaluator(@Nonnull LocalityClass localityClass) {
        this.localityCls = (LocalityClass)((Object)OWLAPIPreconditions.checkNotNull((Object)((Object)localityClass), (String)"localityClass cannot be null"));
        if (!SUPPORTED_LOCALITY_CLASSES.contains((Object)localityClass)) {
            throw new OWLRuntimeException("Unsupported locality class: " + (Object)((Object)localityClass));
        }
    }

    public static Set<LocalityClass> supportedLocalityClasses() {
        return SUPPORTED_LOCALITY_CLASSES;
    }

    protected static boolean isTopOrBuiltInDatatype(@Nonnull OWLDataRange dataRange) {
        if (dataRange.isDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn();
        }
        return false;
    }

    protected static boolean isTopOrBuiltInInfiniteDatatype(@Nonnull OWLDataRange dataRange) {
        if (dataRange.isDatatype()) {
            OWLDatatype dataType = dataRange.asOWLDatatype();
            return dataType.isTopDatatype() || dataType.isBuiltIn() && !dataType.getBuiltInDatatype().isFinite();
        }
        return false;
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        return this.axiomVisitor.isLocal(axiom, signature);
    }

    private static class TopEquivalenceEvaluator
    implements OWLClassExpressionVisitor {
        private BottomEquivalenceEvaluator bottomEvaluator;
        private boolean isTopEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;

        TopEquivalenceEvaluator() {
        }

        private boolean isTopEquivalent(@Nonnull OWLClassExpression desc) {
            ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null")).accept((OWLClassExpressionVisitor)this);
            return this.isTopEquivalent;
        }

        @Nonnull
        protected Collection<? extends OWLEntity> getSignature() {
            return (Collection)OWLAPIPreconditions.verifyNotNull(this.signature);
        }

        @Nonnull
        protected LocalityClass getLocality() {
            return (LocalityClass)((Object)OWLAPIPreconditions.verifyNotNull((Object)((Object)this.localityCls)));
        }

        public boolean isTopEquivalent(@Nonnull OWLClassExpression desc, @Nonnull Collection<? extends OWLEntity> sig, @Nonnull LocalityClass locality) {
            this.localityCls = (LocalityClass)((Object)OWLAPIPreconditions.checkNotNull((Object)((Object)locality), (String)"locality cannot be null"));
            this.signature = (Collection)OWLAPIPreconditions.checkNotNull(sig, (String)"sig cannot be null");
            ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null")).accept((OWLClassExpressionVisitor)this);
            return this.isTopEquivalent;
        }

        public void setBottomEvaluator(@Nonnull BottomEquivalenceEvaluator evaluator) {
            this.bottomEvaluator = (BottomEquivalenceEvaluator)OWLAPIPreconditions.checkNotNull((Object)evaluator, (String)"evaluator cannot be null");
        }

        public void visit(OWLClass ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: {
                    this.isTopEquivalent = ce.isOWLThing();
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isTopEquivalent = ce.isOWLThing() || !ce.isOWLNothing() && !this.signature.contains(ce);
                    break;
                }
            }
        }

        public void visit(OWLDataAllValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().asOWLDataProperty()) || ((OWLDataRange)ce.getFiller()).isTopDatatype();
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = ((OWLDataRange)ce.getFiller()).isTopDatatype();
                    break;
                }
            }
        }

        public void visit(OWLDataExactCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = ce.getCardinality() == 0 && !this.signature.contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLDataMaxCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLDataMinCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = ce.getCardinality() == 0;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = ce.getCardinality() == 0 || ce.getCardinality() == 1 && !this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 1 && !this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLDataSomeValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLDataHasValue ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
            }
        }

        public void visit(OWLObjectAllValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().getNamedProperty()) || this.isTopEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.isTopEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectComplementOf ce) {
            this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent(ce.getOperand(), this.getSignature(), this.getLocality());
        }

        public void visit(OWLObjectExactCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = ce.getCardinality() == 0 && (!this.signature.contains(ce.getProperty().getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality()));
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = ce.getCardinality() == 0 && this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality());
                    break;
                }
            }
        }

        public void visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression conj : ce.getOperands()) {
                assert (conj != null);
                if (this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = false;
                return;
            }
            this.isTopEquivalent = true;
        }

        public void visit(OWLObjectMaxCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().getNamedProperty()) || this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality());
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = this.bottomEvaluator.isBottomEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality());
                    break;
                }
            }
        }

        public void visit(OWLObjectMinCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = ce.getCardinality() == 0;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = ce.getCardinality() == 0 || !this.signature.contains(ce.getProperty().getNamedProperty()) && this.isTopEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectOneOf ce) {
            this.isTopEquivalent = false;
        }

        public void visit(OWLObjectHasSelf ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().getNamedProperty());
                    break;
                }
            }
        }

        public void visit(OWLObjectSomeValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().getNamedProperty()) && this.isTopEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectUnionOf ce) {
            for (OWLClassExpression conj : ce.getOperands()) {
                assert (conj != null);
                if (!this.isTopEquivalent(conj)) continue;
                this.isTopEquivalent = true;
                return;
            }
            this.isTopEquivalent = false;
        }

        public void visit(OWLObjectHasValue ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isTopEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isTopEquivalent = !this.signature.contains(ce.getProperty().getNamedProperty());
                    break;
                }
            }
        }
    }

    private static class BottomEquivalenceEvaluator
    implements OWLClassExpressionVisitor {
        private boolean isBottomEquivalent;
        private LocalityClass localityCls;
        private Collection<? extends OWLEntity> signature;
        private TopEquivalenceEvaluator topEvaluator;

        BottomEquivalenceEvaluator() {
        }

        private boolean isBottomEquivalent(@Nonnull OWLClassExpression desc) {
            ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null")).accept((OWLClassExpressionVisitor)this);
            return this.isBottomEquivalent;
        }

        public boolean isBottomEquivalent(@Nonnull OWLClassExpression desc, @Nonnull Collection<? extends OWLEntity> sig, @Nonnull LocalityClass locality) {
            this.localityCls = (LocalityClass)((Object)OWLAPIPreconditions.checkNotNull((Object)((Object)locality), (String)"locality cannot be null"));
            this.signature = (Collection)OWLAPIPreconditions.checkNotNull(sig, (String)"sig cannot be null");
            ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)desc, (String)"desc cannot be null")).accept((OWLClassExpressionVisitor)this);
            return this.isBottomEquivalent;
        }

        @Nonnull
        protected Collection<? extends OWLEntity> getSignature() {
            return (Collection)OWLAPIPreconditions.verifyNotNull(this.signature);
        }

        @Nonnull
        protected LocalityClass getLocality() {
            return (LocalityClass)((Object)OWLAPIPreconditions.verifyNotNull((Object)((Object)this.localityCls)));
        }

        public void setTopEvaluator(@Nonnull TopEquivalenceEvaluator evaluator) {
            this.topEvaluator = (TopEquivalenceEvaluator)OWLAPIPreconditions.checkNotNull((Object)evaluator, (String)"evaluator cannot be null");
        }

        public void visit(OWLClass ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: {
                    this.isBottomEquivalent = ce.isOWLNothing() || !ce.isOWLThing() && !this.getSignature().contains(ce);
                    break;
                }
                case TOP_BOTTOM: 
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.isOWLNothing();
                    break;
                }
            }
        }

        public void visit(OWLDataAllValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && !((OWLDataRange)ce.getFiller()).isTopDatatype();
                    break;
                }
            }
        }

        public void visit(OWLDataExactCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.getCardinality() == 0 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 0 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLDataMaxCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.getCardinality() == 0 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() == 1 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInDatatype((OWLDataRange)ce.getFiller()) || ce.getCardinality() > 1 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty()) && SyntacticLocalityEvaluator.isTopOrBuiltInInfiniteDatatype((OWLDataRange)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLDataMinCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && !this.getSignature().contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLDataSomeValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLDataHasValue ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLObjectAllValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().getNamedProperty()) && this.isBottomEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectComplementOf ce) {
            this.isBottomEquivalent = this.topEvaluator.isTopEquivalent(ce.getOperand(), this.getSignature(), this.getLocality());
        }

        public void visit(OWLObjectExactCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && (!this.getSignature().contains(ce.getProperty().getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)ce.getFiller()));
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && (this.isBottomEquivalent((OWLClassExpression)ce.getFiller()) || !this.getSignature().contains(ce.getProperty().getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality()));
                    break;
                }
            }
        }

        public void visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression conj : ce.getOperands()) {
                assert (conj != null);
                if (!this.isBottomEquivalent(conj)) continue;
                this.isBottomEquivalent = true;
                return;
            }
            this.isBottomEquivalent = false;
        }

        public void visit(OWLObjectMaxCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = false;
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && !this.getSignature().contains(ce.getProperty().getNamedProperty()) && this.topEvaluator.isTopEquivalent((OWLClassExpression)ce.getFiller(), this.getSignature(), this.getLocality());
                    break;
                }
            }
        }

        public void visit(OWLObjectMinCardinality ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && (!this.getSignature().contains(ce.getProperty().getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)ce.getFiller()));
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = ce.getCardinality() > 0 && this.isBottomEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectOneOf ce) {
            this.isBottomEquivalent = ce.getIndividuals().isEmpty();
        }

        public void visit(OWLObjectHasSelf ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                    break;
                }
            }
        }

        public void visit(OWLObjectSomeValuesFrom ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().getNamedProperty()) || this.isBottomEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = this.isBottomEquivalent((OWLClassExpression)ce.getFiller());
                    break;
                }
            }
        }

        public void visit(OWLObjectUnionOf ce) {
            for (OWLClassExpression disj : ce.getOperands()) {
                assert (disj != null);
                if (this.isBottomEquivalent(disj)) continue;
                this.isBottomEquivalent = false;
                return;
            }
            this.isBottomEquivalent = true;
        }

        public void visit(OWLObjectHasValue ce) {
            switch (this.getLocality()) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isBottomEquivalent = !this.getSignature().contains(ce.getProperty().getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isBottomEquivalent = false;
                    break;
                }
            }
        }
    }

    private class AxiomLocalityVisitor
    implements OWLAxiomVisitor {
        @Nonnull
        private final BottomEquivalenceEvaluator bottomEvaluator = new BottomEquivalenceEvaluator();
        private boolean isLocal;
        private Collection<? extends OWLEntity> signature;
        @Nonnull
        private final TopEquivalenceEvaluator topEvaluator = new TopEquivalenceEvaluator();

        AxiomLocalityVisitor() {
            this.topEvaluator.setBottomEvaluator(this.bottomEvaluator);
            this.bottomEvaluator.setTopEvaluator(this.topEvaluator);
        }

        @Nonnull
        protected Collection<? extends OWLEntity> getSignature() {
            return (Collection)OWLAPIPreconditions.verifyNotNull(this.signature);
        }

        public boolean isLocal(@Nonnull OWLAxiom axiom, @Nonnull Collection<? extends OWLEntity> sig) {
            this.signature = (Collection)OWLAPIPreconditions.checkNotNull(sig, (String)"sig cannot be null");
            this.isLocal = false;
            ((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")).accept((OWLAxiomVisitor)this);
            return this.isLocal;
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getClassExpression(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()) || ((OWLDataRange)axiom.getRange()).isTopDatatype();
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = ((OWLDataRange)axiom.getRange()).isTopDatatype();
                    break;
                }
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
                    break;
                }
            }
        }

        public void visit(OWLDeclarationAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            Set disjs = axiom.getClassExpressions();
            int size = disjs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                boolean nonBottomEquivDescFound = false;
                for (OWLClassExpression desc : disjs) {
                    assert (desc != null);
                    if (this.bottomEvaluator.isBottomEquivalent(desc, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) continue;
                    if (nonBottomEquivDescFound) {
                        this.isLocal = false;
                        return;
                    }
                    nonBottomEquivDescFound = true;
                }
            }
            this.isLocal = true;
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        this.isLocal = true;
                    } else {
                        boolean nonBottomEquivPropFound = false;
                        for (OWLDataPropertyExpression dpe : disjs) {
                            if (!this.getSignature().contains(dpe.asOWLDataProperty())) continue;
                            if (nonBottomEquivPropFound) {
                                this.isLocal = false;
                                return;
                            }
                            nonBottomEquivPropFound = true;
                        }
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    Set disjs = axiom.getProperties();
                    int size = disjs.size();
                    if (size == 1) {
                        this.isLocal = true;
                    } else {
                        boolean nonBottomEquivPropFound = false;
                        for (OWLObjectPropertyExpression ope : disjs) {
                            if (!this.getSignature().contains(ope.getNamedProperty())) continue;
                            if (nonBottomEquivPropFound) {
                                this.isLocal = false;
                                return;
                            }
                            nonBottomEquivPropFound = true;
                        }
                    }
                    this.isLocal = true;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            OWLClass lhs = axiom.getOWLClass();
            Set rhs = axiom.getClassExpressions();
            if (SyntacticLocalityEvaluator.this.localityCls == LocalityClass.BOTTOM_BOTTOM) {
                if (!this.getSignature().contains(lhs)) {
                    for (OWLClassExpression desc : rhs) {
                        assert (desc != null);
                        if (this.bottomEvaluator.isBottomEquivalent(desc, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) continue;
                        this.isLocal = false;
                        return;
                    }
                    this.isLocal = true;
                } else {
                    this.isLocal = false;
                }
            } else if (!this.getSignature().contains(lhs)) {
                boolean topEquivDescFound = false;
                for (OWLClassExpression desc : rhs) {
                    assert (desc != null);
                    if (this.bottomEvaluator.isBottomEquivalent(desc, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) continue;
                    if (this.topEvaluator.isTopEquivalent(desc, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) {
                        if (topEquivDescFound) {
                            this.isLocal = false;
                            return;
                        }
                        topEquivDescFound = true;
                        continue;
                    }
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            } else {
                this.isLocal = false;
            }
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.isLocal = true;
            Iterator eqs = axiom.getClassExpressions().iterator();
            OWLClassExpression first = (OWLClassExpression)eqs.next();
            assert (first != null);
            if (!eqs.hasNext()) {
                return;
            }
            boolean isBottom = this.bottomEvaluator.isBottomEquivalent(first, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
            if (!isBottom && !this.topEvaluator.isTopEquivalent(first, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) {
                this.isLocal = false;
            }
            if (isBottom) {
                while (this.isLocal && eqs.hasNext()) {
                    OWLClassExpression next = (OWLClassExpression)eqs.next();
                    assert (next != null);
                    if (this.bottomEvaluator.isBottomEquivalent(next, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            } else {
                while (this.isLocal && eqs.hasNext()) {
                    OWLClassExpression next = (OWLClassExpression)eqs.next();
                    assert (next != null);
                    if (this.topEvaluator.isTopEquivalent(next, this.getSignature(), SyntacticLocalityEvaluator.this.localityCls)) continue;
                    this.isLocal = false;
                }
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLDataPropertyExpression p : eqs) {
                    if (!this.getSignature().contains(p.asOWLDataProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            Set eqs = axiom.getProperties();
            int size = eqs.size();
            if (size == 1) {
                this.isLocal = true;
            } else {
                for (OWLObjectPropertyExpression p : eqs) {
                    if (!this.getSignature().contains(p.getNamedProperty())) continue;
                    this.isLocal = false;
                    return;
                }
                this.isLocal = true;
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.isLocal = !this.getSignature().contains(axiom.getFirstProperty().getNamedProperty()) && !this.getSignature().contains(axiom.getSecondProperty().getNamedProperty());
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    for (OWLObjectPropertyExpression ope : axiom.getPropertyChain()) {
                        if (this.getSignature().contains(ope.getNamedProperty())) continue;
                        this.isLocal = true;
                        return;
                    }
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    if (!this.getSignature().contains(axiom.getSuperProperty().getNamedProperty())) {
                        this.isLocal = true;
                        break;
                    }
                    this.isLocal = false;
                    break;
                }
            }
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent(axiom.getDomain(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()) || this.topEvaluator.isTopEquivalent((OWLClassExpression)axiom.getRange(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = this.topEvaluator.isTopEquivalent((OWLClassExpression)axiom.getRange(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
                    break;
                }
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
                    break;
                }
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            switch (SyntacticLocalityEvaluator.this.localityCls) {
                case BOTTOM_BOTTOM: 
                case TOP_BOTTOM: {
                    this.isLocal = false;
                    break;
                }
                case TOP_TOP: {
                    this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
                    break;
                }
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.isLocal = this.bottomEvaluator.isBottomEquivalent(axiom.getSubClass(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls) || this.topEvaluator.isTopEquivalent(axiom.getSuperClass(), this.getSignature(), SyntacticLocalityEvaluator.this.localityCls);
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.isLocal = !this.getSignature().contains(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty());
        }

        public void visit(SWRLRule rule) {
            this.isLocal = false;
        }

        public void visit(OWLHasKeyAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            this.isLocal = true;
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            this.isLocal = true;
        }
    }
}

