/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.writer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class OBOFormatWriter {
    private static final Logger LOG = LoggerFactory.getLogger(OBOFormatWriter.class);
    private static final Comparator<Frame> framesComparator = Comparator.comparing(Frame::getId);
    private static final Set<String> TAGSINFORMATIVE = OBOFormatWriter.buildTagsInformative();
    private static final Comparator<Clause> clauseComparator = (o1, o2) -> OBOFormatWriter.compare(o1, o2);
    private static Comparator<Clause> clauseListComparator = Comparator.comparing(Clause::getTag, OBOFormatConstants.tagPriority).thenComparing(clauseComparator);
    private boolean isCheckStructure = true;

    private static Set<String> buildTagsInformative() {
        HashSet<String> set = new HashSet<String>();
        set.add(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER.getTag());
        return set;
    }

    private static void writeLine(StringBuilder ln, Writer writer) throws IOException {
        ln.append('\n');
        writer.write(ln.toString());
    }

    private static void writeLine(String ln, Writer writer) throws IOException {
        writer.write(ln + '\n');
    }

    private static void writeEmptyLine(Writer writer) throws IOException {
        writer.write("\n");
    }

    private static List<String> duplicateTags(Set<String> src) {
        return new ArrayList<String>(src);
    }

    private static void writeXRefClause(Clause clause, Writer writer) throws IOException {
        Xref xref = clause.getValue(Xref.class);
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        String idref = xref.getIdref();
        int colonPos = idref.indexOf(58);
        if (colonPos > 0) {
            sb.append(OBOFormatWriter.escapeOboString(idref.substring(0, colonPos), EscapeMode.XREF));
            sb.append(':');
            sb.append(OBOFormatWriter.escapeOboString(idref.substring(colonPos + 1), EscapeMode.XREF));
        } else {
            sb.append(OBOFormatWriter.escapeOboString(idref, EscapeMode.XREF));
        }
        String annotation = xref.getAnnotation();
        if (annotation != null) {
            sb.append(" \"");
            sb.append(OBOFormatWriter.escapeOboString(annotation, EscapeMode.QUOTES));
            sb.append('\"');
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeSynonymtypedef(Clause clause, Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        Collection<Object> values = clause.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String value = valuesIterator.next().toString();
            if (i == 1) {
                sb.append('\"');
            }
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.QUOTES));
            if (i == 1) {
                sb.append('\"');
            }
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeHeaderDate(Clause clause, Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Object value = clause.getValue();
        if (value instanceof Date) {
            sb.append(OBOFormatConstants.headerDateFormat().format((Date)value));
        } else if (value instanceof String) {
            sb.append(value);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Unknown datatype ('{}') for value in clause: {}", (Object)value.getClass().getName(), (Object)clause);
            sb.append(value);
        }
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeIdSpace(Clause cl, Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder(cl.getTag());
        sb.append(": ");
        Collection<Object> values = cl.getValues();
        Iterator<Object> iterator = values.iterator();
        for (int i = 0; iterator.hasNext() && i < 3; ++i) {
            String value = iterator.next().toString();
            if (i == 2) {
                sb.append('\"').append(OBOFormatWriter.escapeOboString(value, EscapeMode.QUOTES)).append('\"');
                continue;
            }
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.SIMPLE)).append(' ');
        }
        OBOFormatWriter.appendQualifiers(sb, cl);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeClauseWithQuotedString(Clause clause, Writer writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        boolean first = true;
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        while (valuesIterator.hasNext()) {
            if (first) {
                sb.append('\"');
            }
            String value = valuesIterator.next().toString();
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.QUOTES));
            if (first) {
                sb.append('\"');
            }
            if (valuesIterator.hasNext()) {
                sb.append(' ');
            }
            first = false;
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (!xrefs.isEmpty()) {
            OBOFormatWriter.appendXrefs(sb, xrefs);
        } else if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clause.getTag())) {
            sb.append(" []");
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void appendXrefs(StringBuilder sb, Collection<Xref> xrefs) {
        ArrayList<Xref> sortedXrefs = new ArrayList<Xref>(xrefs);
        Collections.sort(sortedXrefs, XrefComparator.INSTANCE);
        sb.append(" [");
        Iterator xrefsIterator = sortedXrefs.iterator();
        while (xrefsIterator.hasNext()) {
            Xref current = (Xref)xrefsIterator.next();
            String idref = current.getIdref();
            int colonPos = idref.indexOf(58);
            if (colonPos > 0) {
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(0, colonPos), EscapeMode.XREFLIST));
                sb.append(':');
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(colonPos + 1), EscapeMode.XREFLIST));
            } else {
                sb.append(OBOFormatWriter.escapeOboString(idref, EscapeMode.XREFLIST));
            }
            String annotation = current.getAnnotation();
            if (annotation != null) {
                sb.append(' ');
                sb.append('\"');
                sb.append(OBOFormatWriter.escapeOboString(annotation, EscapeMode.QUOTES));
                sb.append('\"');
            }
            if (!xrefsIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
    }

    public static void writeDef(Clause clause, Writer writer) throws IOException {
        OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
    }

    public static void writePropertyValue(Clause clause, Writer writer) throws IOException {
        Collection<Object> cols = clause.getValues();
        if (cols.size() < 2) {
            LOG.error("The {} has incorrect number of values: {}", (Object)OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), (Object)clause);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> it = cols.iterator();
        String property = it.next().toString();
        sb.append(OBOFormatWriter.escapeOboString(property, EscapeMode.SIMPLE));
        while (it.hasNext()) {
            sb.append(' ');
            String val = it.next().toString();
            sb.append('\"');
            sb.append(OBOFormatWriter.escapeOboString(val, EscapeMode.QUOTES));
            sb.append('\"');
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    public static void writeSynonym(Clause clause, Writer writer) throws IOException {
        OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
    }

    public static void write(Clause clause, Writer writer, @Nullable NameProvider nameProvider) throws IOException {
        String trimmed;
        Object value;
        if (OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag().equals(clause.getTag()) && ((value = clause.getValue()) instanceof Boolean ? Boolean.FALSE.equals(value) : !Boolean.TRUE.toString().equals(value))) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        StringBuilder idsLabel = null;
        if (nameProvider != null && TAGSINFORMATIVE.contains(clause.getTag())) {
            idsLabel = new StringBuilder();
        }
        while (valuesIterator.hasNext()) {
            String label;
            String value2 = valuesIterator.next().toString();
            if (idsLabel != null && nameProvider != null && (label = nameProvider.getName(value2)) != null && (OBOFormatWriter.isOpaqueIdentifier(value2) || !valuesIterator.hasNext())) {
                if (idsLabel.length() > 0) {
                    idsLabel.append(' ');
                }
                idsLabel.append(label);
            }
            EscapeMode mode = EscapeMode.MOST;
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(clause.getTag())) {
                mode = EscapeMode.PARENTHESIS;
            }
            sb.append(OBOFormatWriter.escapeOboString(value2, mode));
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (!xrefs.isEmpty()) {
            OBOFormatWriter.appendXrefs(sb, xrefs);
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        if (idsLabel != null && idsLabel.length() > 0 && !(trimmed = idsLabel.toString().trim()).isEmpty()) {
            sb.append(" ! ");
            sb.append(trimmed);
        }
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static boolean isOpaqueIdentifier(@Nullable String value) {
        int colonPos;
        boolean result = false;
        if (value != null && !value.isEmpty() && (colonPos = value.indexOf(58)) > 0 && value.length() > colonPos + 1) {
            result = true;
            for (int i = colonPos; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isDigit(c) || c == ':') continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static void appendQualifiers(StringBuilder sb, Clause clause) {
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        if (!qvs.isEmpty()) {
            sb.append(" {");
            Iterator<QualifierValue> qvsIterator = qvs.iterator();
            while (qvsIterator.hasNext()) {
                QualifierValue qv = qvsIterator.next();
                sb.append(qv.getQualifier());
                sb.append("=\"");
                sb.append(OBOFormatWriter.escapeOboString(qv.getValue(), EscapeMode.QUOTES));
                sb.append('\"');
                if (!qvsIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        }
    }

    private static CharSequence escapeOboString(String in, EscapeMode mode) {
        String replace = in.replace("\\", "\\\\");
        if (mode == EscapeMode.MOST || mode == EscapeMode.QUOTES) {
            replace = replace.replace("\"", "\\\"");
        }
        replace = replace.replace("\n", "\\n");
        if (mode == EscapeMode.MOST || mode == EscapeMode.PARENTHESIS) {
            replace = replace.replace("{", "\\{").replace("}", "\\}");
        }
        if (mode == EscapeMode.XREF || mode == EscapeMode.XREFLIST) {
            replace = replace.replace(",", "\\,").replace(":", "\\:");
        }
        if (mode == EscapeMode.XREFLIST) {
            replace = replace.replace("[", "\\[").replace("]", "\\]");
        }
        return replace;
    }

    public static void sortTermClauses(List<Clause> clauses) {
        Collections.sort(clauses, clauseListComparator);
    }

    private static int compare(Clause o1, Clause o2) {
        int comp;
        String tag = o1.getTag();
        if (OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag().equals(tag)) {
            int s2;
            int s1 = o1.getValues().size();
            if (s1 < (s2 = o2.getValues().size())) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
        }
        if ((comp = OBOFormatWriter.compareValues(o1.getValue(), o2.getValue())) != 0) {
            return comp;
        }
        return OBOFormatWriter.compareValues(o1.getValue2(), o2.getValue2());
    }

    private static int compareValues(@Nullable Object o1, @Nullable Object o2) {
        String s2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String s1 = OBOFormatWriter.toStringRepresentation(o1);
        int comp = s1.compareToIgnoreCase(s2 = OBOFormatWriter.toStringRepresentation(o2));
        if (comp == 0) {
            comp = s1.compareTo(s2);
        }
        return comp;
    }

    private static String toStringRepresentation(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Xref) {
            Xref xref = (Xref)obj;
            return xref.getIdref() + ' ' + xref.getAnnotation();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public boolean isCheckStructure() {
        return this.isCheckStructure;
    }

    public void setCheckStructure(boolean isCheckStructure) {
        this.isCheckStructure = isCheckStructure;
    }

    public void write(String fn, Writer writer) throws IOException {
        if (fn.startsWith("http:")) {
            this.write(new URL(fn), writer);
        } else {
            try (FileReader r = new FileReader(new File(fn));
                 BufferedReader reader = new BufferedReader(r);){
                this.write(reader, writer);
            }
        }
    }

    public void write(URL url, Writer writer) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        this.write(reader, writer);
    }

    public void write(Reader reader, Writer writer) throws IOException {
        OBOFormatParser parser = new OBOFormatParser();
        OBODoc doc = parser.parse(reader);
        this.write(doc, writer);
    }

    public void write(OBODoc doc, String outFilename) throws IOException {
        this.write(doc, new File(outFilename));
    }

    public void write(OBODoc doc, File outFile) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outFile);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);){
            this.write(doc, (Writer)bw);
        }
    }

    public void write(OBODoc doc, Writer writer) throws IOException {
        OBODocNameProvider nameProvider = new OBODocNameProvider(doc);
        this.write(doc, writer, (NameProvider)nameProvider);
    }

    public void write(OBODoc doc, Writer writer, NameProvider nameProvider) throws IOException {
        if (this.isCheckStructure) {
            doc.check();
        }
        Frame headerFrame = doc.getHeaderFrame();
        this.writeHeader((Frame)OWLAPIPreconditions.checkNotNull((Object)headerFrame), writer, nameProvider);
        ArrayList<Frame> termFrames = new ArrayList<Frame>();
        termFrames.addAll(doc.getTermFrames());
        Collections.sort(termFrames, framesComparator);
        ArrayList<Frame> typeDefFrames = new ArrayList<Frame>();
        typeDefFrames.addAll(doc.getTypedefFrames());
        Collections.sort(typeDefFrames, framesComparator);
        ArrayList instanceFrames = new ArrayList();
        typeDefFrames.addAll(doc.getInstanceFrames());
        Collections.sort(instanceFrames, framesComparator);
        for (Frame f : termFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : typeDefFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : instanceFrames) {
            this.write(f, writer, nameProvider);
        }
        writer.flush();
    }

    public void writeHeader(Frame frame, Writer writer, NameProvider nameProvider) throws IOException {
        List<String> tags = OBOFormatWriter.duplicateTags(frame.getTags());
        Collections.sort(tags, OBOFormatConstants.headerPriority);
        OBOFormatWriter.write(new Clause(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag(), "1.2"), writer, nameProvider);
        for (String tag : tags) {
            if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag())) continue;
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, clauseComparator);
            for (Clause clause : clauses) {
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag())) {
                    OBOFormatWriter.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag())) {
                    OBOFormatWriter.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_DATE.getTag())) {
                    OBOFormatWriter.writeHeaderDate(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag())) {
                    OBOFormatWriter.writePropertyValue(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_IDSPACE.getTag())) {
                    OBOFormatWriter.writeIdSpace(clause, writer);
                    continue;
                }
                OBOFormatWriter.write(clause, writer, nameProvider);
            }
        }
        OBOFormatWriter.writeEmptyLine(writer);
    }

    public void write(Frame frame, Writer writer, @Nullable NameProvider nameProvider) throws IOException {
        Comparator<String> comparator = null;
        if (frame.getType() == Frame.FrameType.TERM) {
            OBOFormatWriter.writeLine("[Term]", writer);
            comparator = OBOFormatConstants.tagPriority;
        } else if (frame.getType() == Frame.FrameType.TYPEDEF) {
            OBOFormatWriter.writeLine("[Typedef]", writer);
            comparator = OBOFormatConstants.typeDefPriority;
        } else if (frame.getType() == Frame.FrameType.INSTANCE) {
            OBOFormatWriter.writeLine("[Instance]", writer);
            comparator = OBOFormatConstants.typeDefPriority;
        }
        String id = frame.getId();
        if (id != null) {
            Object label = frame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_NAME);
            String extra = "";
            if (label == null && nameProvider != null && (label = nameProvider.getName(id)) != null) {
                extra = " ! " + label;
            }
            OBOFormatWriter.writeLine(OBOFormatConstants.OboFormatTag.TAG_ID.getTag() + ": " + id + extra, writer);
        }
        List<String> tags = OBOFormatWriter.duplicateTags(frame.getTags());
        Collections.sort(tags, comparator);
        String defaultOboNamespace = null;
        if (nameProvider != null) {
            defaultOboNamespace = nameProvider.getDefaultOboNamespace();
        }
        for (String tag : tags) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, clauseComparator);
            for (Clause clause : clauses) {
                String clauseTag = clause.getTag();
                if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(clauseTag)) continue;
                if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeDef(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeSynonym(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writePropertyValue(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clauseTag) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeXRefClause(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag().equals(clauseTag)) {
                    if (defaultOboNamespace != null && clause.getValue().equals(defaultOboNamespace)) continue;
                    OBOFormatWriter.write(clause, writer, nameProvider);
                    continue;
                }
                OBOFormatWriter.write(clause, writer, nameProvider);
            }
        }
        OBOFormatWriter.writeEmptyLine(writer);
    }

    public static class OWLOntologyNameProvider
    implements NameProvider {
        private final OWLOntology ont;
        @Nullable
        private final String defaultOboNamespace;
        private final OBODoc result;

        public OWLOntologyNameProvider(OWLOntology ont, @Nullable String defaultOboNamespace, OBODoc result) {
            this.ont = ont;
            this.defaultOboNamespace = defaultOboNamespace;
            this.result = result;
        }

        @Override
        @Nullable
        public String getName(String id) {
            OWLAPIObo2Owl obo2owl = new OWLAPIObo2Owl(this.ont.getOWLOntologyManager());
            obo2owl.setObodoc(this.result);
            IRI iri = obo2owl.oboIdToIRI(id);
            List axioms = OWLAPIStreamUtils.asList((Stream)this.ont.axioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)iri, Imports.INCLUDED, Navigation.IN_SUB_POSITION));
            for (OWLAnnotationAssertionAxiom axiom : axioms) {
                OWLAnnotationValue value;
                if (!((OWLAnnotationProperty)axiom.getProperty()).isLabel() || !((value = axiom.getValue()) instanceof OWLLiteral)) continue;
                return ((OWLLiteral)value).getLiteral();
            }
            return null;
        }

        @Override
        @Nullable
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    public static class OBODocNameProvider
    implements NameProvider {
        private final OBODoc oboDoc;
        @Nullable
        private final String defaultOboNamespace;

        public OBODocNameProvider(OBODoc oboDoc) {
            this.oboDoc = oboDoc;
            Frame headerFrame = oboDoc.getHeaderFrame();
            this.defaultOboNamespace = headerFrame != null ? headerFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, String.class) : null;
        }

        @Override
        @Nullable
        public String getName(String id) {
            Clause cl;
            String name = null;
            Frame frame = this.oboDoc.getTermFrame(id);
            if (frame == null) {
                frame = this.oboDoc.getTypedefFrame(id);
            }
            if (frame != null && (cl = frame.getClause(OBOFormatConstants.OboFormatTag.TAG_NAME)) != null) {
                name = cl.getValue(String.class);
            }
            return name;
        }

        @Override
        @Nullable
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    private static class XrefComparator
    implements Comparator<Xref>,
    Serializable {
        static final XrefComparator INSTANCE = new XrefComparator();

        private XrefComparator() {
        }

        @Override
        public int compare(@Nullable Xref o1, @Nullable Xref o2) {
            String idref1 = ((Xref)OWLAPIPreconditions.checkNotNull((Object)o1)).getIdref();
            String idref2 = ((Xref)OWLAPIPreconditions.checkNotNull((Object)o2)).getIdref();
            return idref1.compareToIgnoreCase(idref2);
        }
    }

    public static interface NameProvider {
        @Nullable
        public String getName(String var1);

        @Nullable
        public String getDefaultOboNamespace();
    }

    private static enum EscapeMode {
        MOST,
        PARENTHESIS,
        QUOTES,
        XREF,
        XREFLIST,
        SIMPLE;

    }
}

